/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.html.HtmlCalendar;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.partrenderer.TooltipPartRenderer;
import de.larmic.butterfaces.component.renderkit.html_basic.AbstractTextRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.CalendarRenderer")
public class CalendarRenderer
extends AbstractTextRenderer<HtmlCalendar> {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlCalendar calendar = (HtmlCalendar)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!calendar.isReadonly()) {
            super.encodeSuperEnd(context, component);
            if (calendar.isPickDate() || calendar.isPickTime()) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"input-group-addon", null);
                writer.startElement("span", component);
                writer.endElement("span");
                writer.endElement("span");
            }
        }
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd((HtmlInputComponent)calendar, writer);
        new TooltipPartRenderer().renderTooltip((HtmlInputComponent)calendar, writer);
        if (calendar.isPickDate() || calendar.isPickTime()) {
            writer.startElement("script", (UIComponent)calendar);
            writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)".input-group", (String)this.createJQueryPluginCall(calendar)), null);
            writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)".input-group", (String)this.createJQueryPluginCallback(calendar)), null);
            writer.endElement("script");
        }
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    private String createJQueryPluginCall(HtmlCalendar calendar) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        String calendarDate = StringUtils.getNotNullValue((String)calendar.getGlyphiconDate(), (String)"glyphicon glyphicon-calendar");
        String calendarTime = StringUtils.getNotNullValue((String)calendar.getGlyphiconTime(), (String)"glyphicon glyphicon-time");
        String calendarUp = StringUtils.getNotNullValue((String)calendar.getGlyphiconUp(), (String)"glyphicon glyphicon-chevron-up");
        String calendarDown = StringUtils.getNotNullValue((String)calendar.getGlyphiconDown(), (String)"glyphicon glyphicon-chevron-down");
        jQueryPluginCall.append("datetimepicker({");
        jQueryPluginCall.append("pickTime: " + calendar.isPickTime() + ",");
        jQueryPluginCall.append("pickDate: " + calendar.isPickDate() + ",");
        jQueryPluginCall.append("sideBySide: " + calendar.isSideBySide() + ",");
        jQueryPluginCall.append("icons: {");
        jQueryPluginCall.append("time: '" + calendarTime + "',");
        jQueryPluginCall.append("date: '" + calendarDate + "',");
        jQueryPluginCall.append("up: '" + calendarUp + "',");
        jQueryPluginCall.append("down: '" + calendarDown + "'");
        jQueryPluginCall.append("},");
        jQueryPluginCall.append("language: \"" + calendar.getLanguage() + "\"");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }

    private String createJQueryPluginCallback(HtmlCalendar calendar) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("on(\"dp.change\", function (e) {");
        jQueryPluginCall.append(RenderUtils.createJQueryBySelector((String)calendar.getClientId(), (String)".butter-input-component") + "trigger('keyup');");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }
}

