/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.html.table.HtmlTableToolbar;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.HtmlBasicRenderer;
import de.larmic.butterfaces.resolver.AjaxRequest;
import de.larmic.butterfaces.resolver.AjaxRequestFactory;
import de.larmic.butterfaces.resolver.UIComponentResolver;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.TableHeaderRenderer")
public class TableToolbarRenderer
extends HtmlBasicRenderer {
    private HtmlTable cachedTableComponent;
    private WebXmlParameters webXmlParameters;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlTableToolbar tableHeader = (HtmlTableToolbar)component;
        ResponseWriter responseWriter = context.getResponseWriter();
        this.cachedTableComponent = new UIComponentResolver().findComponent(tableHeader.getTableId(), HtmlTable.class);
        if (this.cachedTableComponent == null) {
            throw new IllegalStateException("Could not find table component with id '" + tableHeader.getTableId() + "'.");
        }
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        responseWriter.startElement("div", (UIComponent)tableHeader);
        this.writeIdAttribute(context, responseWriter, (UIComponent)tableHeader);
        responseWriter.writeAttribute("class", (Object)"butter-table-toolbar", null);
        responseWriter.writeAttribute("data-table-html-id", (Object)this.cachedTableComponent.getClientId(), null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            ResponseWriter responseWriter = context.getResponseWriter();
            responseWriter.startElement("div", component);
            responseWriter.writeAttribute("class", (Object)"butter-table-toolbar-custom pull-left", null);
            super.encodeChildren(context, component);
            responseWriter.endElement("div");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        HtmlTableToolbar tableHeader = (HtmlTableToolbar)component;
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)tableHeader);
        responseWriter.startElement("div", (UIComponent)tableHeader);
        responseWriter.writeAttribute("class", (Object)"btn-group pull-right table-toolbar-default", null);
        this.renderFacet(context, component, "default-options-left");
        this.renderTableToolbarRefreshButton(responseWriter, tableHeader);
        this.renderFacet(context, component, "default-options-center");
        this.renderTableToolbarToggleColumnButton(responseWriter, tableHeader);
        this.renderFacet(context, component, "default-options-right");
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        RenderUtils.renderJQueryPluginCall((String)component.getClientId(), (String)"fixBootstrapDropDown()", (ResponseWriter)responseWriter, (UIComponent)component);
    }

    private void renderFacet(FacesContext context, UIComponent component, String facetName) throws IOException {
        UIComponent leftFacet = this.getFacet(component, facetName);
        if (leftFacet != null) {
            leftFacet.encodeAll(context);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        HtmlTableToolbar htmlTableHeader = (HtmlTableToolbar)component;
        Map behaviors = htmlTableHeader.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null) {
            if (behaviorEvent.startsWith("toggle")) {
                String[] split = behaviorEvent.split("_");
                String event = split[0];
                int eventNumber = Integer.valueOf(split[1]);
                if ("toggle".equals(event) && this.cachedTableComponent.getTableColumnDisplayModel() != null) {
                    HtmlColumn toggledColumn = (HtmlColumn)this.cachedTableComponent.getCachedColumns().get(eventNumber);
                    if (this.isHideColumn(this.cachedTableComponent, toggledColumn)) {
                        this.cachedTableComponent.getTableColumnDisplayModel().showColumn(toggledColumn.getId());
                    } else {
                        this.cachedTableComponent.getTableColumnDisplayModel().hideColumn(toggledColumn.getId());
                    }
                }
            } else if (behaviorEvent.equals("refresh") && htmlTableHeader.getTableToolbarRefreshListener() != null) {
                htmlTableHeader.getTableToolbarRefreshListener().onPreRefresh();
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void renderTableToolbarToggleColumnButton(ResponseWriter writer, HtmlTableToolbar tableToolbar) throws IOException {
        AjaxRequest ajaxRequest = new AjaxRequestFactory().createRequest((UIComponentBase)tableToolbar, "toggle");
        if (ajaxRequest != null) {
            ajaxRequest.getRenderIds().add(this.cachedTableComponent.getClientId());
            writer.startElement("div", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn-group", null);
            writer.startElement("a", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn btn-default dropdown-toggle", null);
            writer.writeAttribute("data-toggle", (Object)"dropdown", null);
            writer.writeAttribute("title", (Object)"Column options", null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.startElement("i", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)this.webXmlParameters.getOptionsGlyphicon(), null);
            writer.endElement("i");
            writer.startElement("span", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"caret", null);
            writer.endElement("span");
            writer.endElement("a");
            writer.startElement("ul", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"dropdown-menu dropdown-menu-form butter-table-toolbar-columns", null);
            writer.writeAttribute("role", (Object)"menu", null);
            int columnNumber = 0;
            for (HtmlColumn cachedColumn : this.cachedTableComponent.getCachedColumns()) {
                writer.startElement("li", (UIComponent)tableToolbar);
                writer.startElement("label", (UIComponent)tableToolbar);
                writer.writeAttribute("class", (Object)"checkbox", null);
                writer.startElement("input", (UIComponent)tableToolbar);
                writer.writeAttribute("type", (Object)"checkbox", null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                String jQueryPluginCall = RenderUtils.createJQueryPluginCall((String)this.cachedTableComponent.getClientId(), (String)("toggleColumnVisibilty({columnIndex:'" + columnNumber + "'})"));
                String ajaxCall = ajaxRequest.createJavaScriptCall("toggle_" + columnNumber, tableToolbar.isAjaxDisableRenderRegionsOnRequest());
                writer.writeAttribute("onclick", (Object)(ajaxCall + ";" + jQueryPluginCall), null);
                if (!this.isHideColumn(this.cachedTableComponent, cachedColumn)) {
                    writer.writeAttribute("checked", (Object)"checked", null);
                }
                writer.endElement("input");
                writer.writeText((Object)cachedColumn.getLabel(), null);
                writer.endElement("label");
                writer.endElement("li");
                ++columnNumber;
            }
            writer.endElement("ul");
            writer.endElement("div");
        }
    }

    private boolean isHideColumn(HtmlTable table, HtmlColumn column) {
        Boolean hideColumn;
        if (table.getTableColumnDisplayModel() != null && (hideColumn = table.getTableColumnDisplayModel().isColumnHidden(column.getId())) != null) {
            return hideColumn;
        }
        return column.isHideColumn();
    }

    private void renderTableToolbarRefreshButton(ResponseWriter writer, HtmlTableToolbar tableToolbar) throws IOException {
        AjaxRequest ajaxRequest = new AjaxRequestFactory().createRequest((UIComponentBase)tableToolbar, "refresh");
        if (ajaxRequest != null) {
            ajaxRequest.getRenderIds().add(this.cachedTableComponent.getClientId());
            String ajaxCall = ajaxRequest.createJavaScriptCall("refresh", tableToolbar.isAjaxDisableRenderRegionsOnRequest());
            writer.startElement("a", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)"btn btn-default", null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.writeAttribute("title", (Object)"Refresh table", null);
            writer.writeAttribute("onclick", (Object)ajaxCall, null);
            writer.startElement("i", (UIComponent)tableToolbar);
            writer.writeAttribute("class", (Object)this.webXmlParameters.getRefreshGlyphicon(), null);
            writer.endElement("i");
            writer.endElement("a");
        }
    }
}

