/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.html.HtmlTags;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.renderkit.html_basic.AbstractTextRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.TagsRenderer")
public class TagsRenderer
extends AbstractTextRenderer<HtmlTags> {
    @Override
    protected boolean encodeReadonly() {
        return false;
    }

    @Override
    protected void encodeEnd(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlTags htmlTags = (HtmlTags)component;
        writer.startElement("script", component);
        writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)".butter-input-component", (String)this.createJQueryPluginCall(htmlTags)), null);
        writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)".butter-input-component", (String)this.createJQueryPluginCallback(htmlTags)), null);
        if (htmlTags.isReadonly()) {
            writer.writeText((Object)RenderUtils.createJQueryPluginCall((String)component.getClientId(), (String)"markTagsInputAsReadonly()"), null);
        }
        writer.endElement("script");
    }

    private String createJQueryPluginCallback(HtmlTags tags) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("on(\"itemAdded\", function (e) {");
        jQueryPluginCall.append(RenderUtils.createJQueryBySelector((String)tags.getClientId(), (String)".butter-input-component") + "trigger('keyup');");
        jQueryPluginCall.append("})");
        jQueryPluginCall.append(".on(\"itemRemoved\", function (e) {");
        jQueryPluginCall.append(RenderUtils.createJQueryBySelector((String)tags.getClientId(), (String)".butter-input-component") + "trigger('keyup');");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }

    private String createJQueryPluginCall(HtmlTags tags) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("tagsinput({");
        if (tags.getMaxChars() != null) {
            jQueryPluginCall.append("maxChars: " + tags.getMaxChars() + ",");
        }
        if (tags.getMaxTags() != null) {
            jQueryPluginCall.append("maxTags: " + tags.getMaxChars() + ",");
        }
        jQueryPluginCall.append("trimValue: " + tags.isTrimValue() + ",");
        jQueryPluginCall.append("allowDuplicates: " + tags.isAllowDuplicates() + ",");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }
}

