/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.table;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.event.TableSingleSelectionListener;
import de.larmic.butterfaces.model.table.SortType;
import de.larmic.butterfaces.resolver.AjaxRequest;
import de.larmic.butterfaces.resolver.AjaxRequestFactory;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.TableRenderer")
public class TableRenderer
extends de.larmic.butterfaces.component.renderkit.html_basic.mojarra.TableRenderer {
    private boolean hasColumnWidthSet;
    private int rowIndex;
    private boolean systemIdentifierHashcodeIsUsedAsCachedRowIdentifier;
    private String cachedRowIdentifier;
    private WebXmlParameters webXmlParameters;

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlTable table = (HtmlTable)component;
        this.hasColumnWidthSet = this.hasColumnWidthSet(table.getCachedColumns());
        this.rowIndex = 0;
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        super.encodeBegin(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter responseWriter = context.getResponseWriter();
        RenderUtils.renderJQueryPluginCall((String)component.getClientId(), (String)"fixBootstrapDropDown()", (ResponseWriter)responseWriter, (UIComponent)component);
    }

    @Override
    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        int columnNumber;
        HtmlTable htmlTable = (HtmlTable)table;
        if (this.hasColumnWidthSet) {
            writer.startElement("colgroup", table);
            columnNumber = 0;
            for (HtmlColumn column : htmlTable.getCachedColumns()) {
                writer.startElement("col", table);
                writer.writeAttribute("class", (Object)"butter-table-colgroup", null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                StringBuilder style = new StringBuilder();
                if (StringUtils.isNotEmpty((String)column.getColWidth())) {
                    style.append("width: ");
                    style.append(column.getColWidth());
                }
                if (this.isHideColumn(htmlTable, column)) {
                    if (style.length() > 0) {
                        style.append("; ");
                    }
                    style.append("display: none");
                }
                if (style.length() > 0) {
                    writer.writeAttribute("style", (Object)style.toString(), null);
                }
                writer.endElement("col");
                ++columnNumber;
            }
            writer.endElement("colgroup");
        }
        writer.startElement("thead", table);
        writer.startElement("tr", table);
        columnNumber = 0;
        AjaxRequest ajaxRequest = new AjaxRequestFactory().createRequest((UIComponentBase)htmlTable, "click");
        if (ajaxRequest != null) {
            ajaxRequest.getRenderIds().add(htmlTable.getClientId());
        }
        for (HtmlColumn column : htmlTable.getCachedColumns()) {
            writer.startElement("th", table);
            writer.writeAttribute("id", (Object)column.getClientId(), null);
            if (column.isSortColumnEnabled() && htmlTable.getTableSortModel() != null) {
                writer.writeAttribute("class", (Object)"butter-component-table-column-header butter-component-table-column-sort", null);
            } else {
                writer.writeAttribute("class", (Object)"butter-component-table-column-header", null);
            }
            writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
            if (this.isHideColumn(htmlTable, column)) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            if (column.isSortColumnEnabled() && htmlTable.getModel() != null && ajaxRequest != null) {
                writer.writeAttribute("onclick", (Object)ajaxRequest.createJavaScriptCall("sort_" + columnNumber, htmlTable.isAjaxDisableRenderRegionsOnRequest()), null);
            }
            writer.startElement("span", table);
            writer.writeAttribute("class", (Object)"butter-component-table-column-label", null);
            writer.writeText((Object)column.getLabel(), null);
            writer.endElement("span");
            if (column.isSortColumnEnabled() && htmlTable.getTableSortModel() != null && ajaxRequest != null) {
                writer.startElement("span", table);
                String tableUniqueIdentifier = StringUtils.getNotNullValue((String)htmlTable.getUniqueIdentifier(), (String)table.getId());
                String columnUniqueIdentifier = StringUtils.getNotNullValue((String)column.getUniqueIdentifier(), (String)column.getId());
                SortType sortType = htmlTable.getModel().getTableSortModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier);
                StringBuilder sortSpanStyleClass = new StringBuilder("butter-component-table-column-sort-spinner ");
                if (sortType == SortType.ASCENDING) {
                    sortSpanStyleClass.append(" " + this.webXmlParameters.getSortAscGlyphicon());
                } else if (sortType == SortType.DESCENDING) {
                    sortSpanStyleClass.append(" " + this.webXmlParameters.getSortDescGlyphicon());
                } else {
                    sortSpanStyleClass.append(" " + this.webXmlParameters.getSortUnknownGlyphicon());
                }
                writer.writeAttribute("class", (Object)sortSpanStyleClass.toString(), null);
                writer.endElement("span");
            }
            writer.endElement("th");
            ++columnNumber;
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    private boolean isHideColumn(HtmlTable table, HtmlColumn column) {
        if (table.getTableColumnDisplayModel() != null) {
            String tableUniqueIdentifier = StringUtils.getNotNullValue((String)table.getUniqueIdentifier(), (String)table.getId());
            String columnUniqueIdentifier = StringUtils.getNotNullValue((String)column.getUniqueIdentifier(), (String)column.getId());
            Boolean hideColumn = table.getTableColumnDisplayModel().isColumnHidden(tableUniqueIdentifier, columnUniqueIdentifier);
            if (hideColumn != null) {
                return hideColumn;
            }
        }
        return column.isHideColumn();
    }

    protected void renderTableStart(FacesContext context, UIComponent component, ResponseWriter writer, Attribute[] attributes) throws IOException {
        HtmlTable table = (HtmlTable)component;
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        writer.writeAttribute("class", (Object)"butter-table", null);
        writer.startElement("div", (UIComponent)table);
        String styleClass = (String)table.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)("table-responsive " + styleClass), "styleClass");
        } else {
            writer.writeAttribute("class", (Object)"table-responsive", "styleClass");
        }
        writer.startElement("table", (UIComponent)table);
        StringBuilder tableStyleClass = new StringBuilder("table table-hover");
        if (this.hasColumnWidthSet) {
            tableStyleClass.append(" table-fixed");
        }
        if (table.isTableCondensed()) {
            tableStyleClass.append(" table-condensed");
        }
        if (table.isTableBordered()) {
            tableStyleClass.append(" table-bordered");
        }
        if (table.isTableStriped()) {
            tableStyleClass.append(" table-striped");
        }
        writer.writeAttribute("class", (Object)tableStyleClass.toString(), "styleClass");
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)table, (Attribute[])attributes);
        writer.writeText((Object)"\n", (UIComponent)table, null);
    }

    protected void renderTableEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        super.renderTableEnd(context, component, writer);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderRowStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String click;
        String rowClass;
        HtmlTable htmlTable = (HtmlTable)component;
        ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)htmlTable, (String)"click", (String)component.getClientId(context), null);
        String clientId = htmlTable.getClientId();
        String baseClientId = clientId.substring(0, clientId.length() - (this.rowIndex + "").length() - 1);
        writer.startElement("tr", (UIComponent)htmlTable);
        writer.writeAttribute("rowIndex", (Object)this.rowIndex, null);
        String string = rowClass = StringUtils.isNotEmpty((String)htmlTable.getRowClass()) ? "butter-table-row " + htmlTable.getRowClass() : "butter-table-row";
        if (this.isRowSelected(context, htmlTable.getVar(), htmlTable.getRowIdentifierProperty())) {
            writer.writeAttribute("class", (Object)(rowClass + " butter-table-row-selected"), null);
        } else {
            writer.writeAttribute("class", (Object)rowClass, null);
        }
        Map behaviors = htmlTable.getClientBehaviors();
        if (behaviors.containsKey("click") && StringUtils.isNotEmpty((String)(click = ((ClientBehavior)((List)behaviors.get("click")).get(0)).getScript(behaviorContext))) && htmlTable.getSingleSelectionListener() != null) {
            String correctedEventName = click.replace(",'click',", ",'click_" + this.rowIndex + "',");
            String correctedClientId = correctedEventName.replaceFirst(clientId, baseClientId);
            String jQueryPluginCall = RenderUtils.createJQueryPluginCall((String)htmlTable.getClientId(), (String)("selectRow({rowIndex:'" + this.rowIndex + "'})"));
            writer.writeAttribute("onclick", (Object)(correctedClientId + ";" + jQueryPluginCall.replaceFirst(clientId, baseClientId)), null);
        }
        writer.writeText((Object)"\n", (UIComponent)htmlTable, null);
        ++this.rowIndex;
    }

    private boolean isRowSelected(FacesContext context, String htmlTableVar, String rowIdentifierProperty) {
        if (StringUtils.isNotEmpty((String)this.cachedRowIdentifier)) {
            String value = this.createRowIdentifierValueExpression(context, htmlTableVar, rowIdentifierProperty);
            return this.cachedRowIdentifier.equals(value);
        }
        return false;
    }

    private String createRowIdentifierValueExpression(FacesContext context, String htmlTableVar, String rowIdentifierProperty) {
        ELContext elContext = context.getELContext();
        String valueExpressionString = this.systemIdentifierHashcodeIsUsedAsCachedRowIdentifier ? "#{" + htmlTableVar + "}" : "#{" + htmlTableVar + "." + rowIdentifierProperty + "}";
        ValueExpression valueExpression = this.createRowIdentifierValueExpression(context, valueExpressionString);
        Object value = valueExpression.getValue(elContext);
        return this.systemIdentifierHashcodeIsUsedAsCachedRowIdentifier ? System.identityHashCode(value) + "" : value.toString();
    }

    private ValueExpression createRowIdentifierValueExpression(FacesContext context, String valueExpression) {
        ELContext elContext = context.getELContext();
        return context.getApplication().getExpressionFactory().createValueExpression(elContext, valueExpression, Object.class);
    }

    public void decode(FacesContext context, UIComponent component) {
        HtmlTable htmlTable = (HtmlTable)component;
        Map behaviors = htmlTable.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Object untypedTableValue = htmlTable.getValue();
        if (!(untypedTableValue instanceof Iterable)) {
            return;
        }
        Iterable tableValues = (Iterable)untypedTableValue;
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && behaviorEvent.contains("_")) {
            String[] split = behaviorEvent.split("_");
            String event = split[0];
            try {
                int eventNumber = Integer.valueOf(split[1]);
                if ("click".equals(event)) {
                    TableSingleSelectionListener listener;
                    Object rowObject = this.findRowObject(tableValues, eventNumber);
                    this.cachedRowIdentifier = null;
                    if (rowObject != null && (listener = htmlTable.getSingleSelectionListener()) != null) {
                        String rowIdentifier;
                        listener.processTableSelection(rowObject);
                        this.cachedRowIdentifier = rowIdentifier = this.getRowIdentifierProperty(rowObject, htmlTable.getRowIdentifierProperty());
                    }
                } else if ("sort".equals(event) && htmlTable.getModel() != null) {
                    HtmlColumn sortedColumn = (HtmlColumn)htmlTable.getCachedColumns().get(eventNumber);
                    String tableUniqueIdentifier = StringUtils.getNotNullValue((String)htmlTable.getUniqueIdentifier(), (String)htmlTable.getId());
                    String columnUniqueIdentifier = StringUtils.getNotNullValue((String)sortedColumn.getUniqueIdentifier(), (String)sortedColumn.getId());
                    if (htmlTable.getTableSortModel().getSortType(tableUniqueIdentifier, columnUniqueIdentifier) == SortType.ASCENDING) {
                        htmlTable.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.DESCENDING);
                    } else {
                        htmlTable.getTableSortModel().sortColumn(tableUniqueIdentifier, columnUniqueIdentifier, sortedColumn.getSortBy(), SortType.ASCENDING);
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private String getRowIdentifierProperty(Object rowObject, String rowIdentifierProperty) {
        this.systemIdentifierHashcodeIsUsedAsCachedRowIdentifier = false;
        if (StringUtils.isNotEmpty((String)rowIdentifierProperty)) {
            String identifier = this.getRowIdentifierPropertyByField(rowObject, rowIdentifierProperty);
            if (StringUtils.isEmpty((String)identifier)) {
                identifier = this.getRowIdentifierPropertyByGetter(rowObject, rowIdentifierProperty);
            }
            if (StringUtils.isNotEmpty((String)identifier)) {
                return identifier;
            }
        }
        this.systemIdentifierHashcodeIsUsedAsCachedRowIdentifier = true;
        return System.identityHashCode(rowObject) + "";
    }

    private String getRowIdentifierPropertyByField(Object rowObject, String rowIdentifierProperty) {
        try {
            Method method = rowObject.getClass().getMethod("get" + this.toUpperCase(rowIdentifierProperty), new Class[0]);
            Object valueObject = method.invoke(rowObject, (Object[])null);
            return this.convertRowIdentifierToString(valueObject);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private String toUpperCase(String str) {
        return Character.toString(str.charAt(0)).toUpperCase() + str.substring(1);
    }

    private String getRowIdentifierPropertyByGetter(Object rowObject, String rowIdentifierProperty) {
        try {
            Field declaredField = rowObject.getClass().getDeclaredField(rowIdentifierProperty);
            declaredField.setAccessible(true);
            return this.convertRowIdentifierToString(declaredField.get(rowObject));
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private String convertRowIdentifierToString(Object rowIdentifier) throws IllegalAccessException {
        String rowIdentifierAsString;
        if (rowIdentifier != null && StringUtils.isNotEmpty((String)(rowIdentifierAsString = rowIdentifier.toString()))) {
            return rowIdentifierAsString;
        }
        return null;
    }

    private Object findRowObject(Iterable tableValues, int row) {
        Iterator iterator = tableValues.iterator();
        int actualRow = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (actualRow == row) {
                return value;
            }
            ++actualRow;
        }
        return null;
    }

    private boolean hasColumnWidthSet(List<HtmlColumn> columns) {
        for (HtmlColumn column : columns) {
            if (!StringUtils.isNotEmpty((String)column.getColWidth())) continue;
            return true;
        }
        return false;
    }
}

