/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.action;

import de.larmic.butterfaces.component.html.action.HtmlCommandLink;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.resolver.AjaxClientIdResolver;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.commandLinkRenderer")
public class CommandLinkRenderer
extends com.sun.faces.renderkit.html_basic.CommandLinkRenderer {
    private static final String WEB_XML_AJAX_PROCESSING_TEXT = "de.larmic.butterfaces.ajaxProcessingTextOnRequest";
    private String onEventCallback = null;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.onEventCallback = null;
        super.encodeBegin(context, component);
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        return true;
    }

    protected void writeCommonLinkAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        String styleClass = (String)component.getAttributes().get("styleClass");
        StringBuilder generatedStyleClass = new StringBuilder(StringUtils.isEmpty((String)styleClass) ? "" : styleClass);
        if (link.isDisabled()) {
            generatedStyleClass.append(" disabled");
        }
        if (generatedStyleClass.length() > 0) {
            writer.writeAttribute("class", (Object)generatedStyleClass.toString(), "styleClass");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter responseWriter = context.getResponseWriter();
        if (link.isAjaxDisableLinkOnRequest()) {
            responseWriter.startElement("script", component);
            responseWriter.writeText((Object)("function " + this.getOnEventListenerName(component) + "(data) {"), null);
            if (StringUtils.isNotEmpty((String)this.onEventCallback)) {
                responseWriter.writeText((Object)("    " + this.onEventCallback + "(data);"), null);
            }
            String processingText = this.createAjaxProcessingText(link);
            AjaxClientIdResolver ajaxClientIdResolver = new AjaxClientIdResolver((UIComponent)link);
            String jQueryIDSelector = link.isAjaxDisableRenderRegionsOnRequest() ? ajaxClientIdResolver.getjQueryRenderIDSelector() : "undefined";
            responseWriter.writeText((Object)("    butter.link.disableOnClick(data, " + link.isAjaxShowWaitingDotsOnRequest() + ",'" + link.getValue() + "','" + processingText + "'," + link.isAjaxHideGlyphiconOnRequest() + ",'" + jQueryIDSelector + "');"), null);
            responseWriter.writeText((Object)"}", null);
            responseWriter.endElement("script");
        }
        super.encodeEnd(context, component);
    }

    private String createAjaxProcessingText(HtmlCommandLink link) {
        if (StringUtils.isNotEmpty((String)link.getAjaxProcessingTextOnRequest())) {
            return link.getAjaxProcessingTextOnRequest();
        }
        String ajaxProcessingTextByWebXml = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(WEB_XML_AJAX_PROCESSING_TEXT);
        return StringUtils.isEmpty((String)ajaxProcessingTextByWebXml) ? "Processing" : ajaxProcessingTextByWebXml;
    }

    protected void writeValue(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCommandLink commandLink = (HtmlCommandLink)component;
        this.writeGlyphiconIfNecessary(commandLink, writer);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"butter-component-glyphicon-text", null);
        super.writeValue(component, writer);
        writer.endElement("span");
        this.writeWaitingDotsIfNecessary(commandLink, writer);
    }

    protected void renderAsActive(FacesContext context, UIComponent component) throws IOException {
        AbstractMap behaviors;
        List actionBehaviours;
        AjaxBehavior ajaxBehavior = null;
        if (((HtmlCommandLink)component).isAjaxDisableLinkOnRequest() && (actionBehaviours = (List)(behaviors = (AbstractMap)((ClientBehaviorHolder)component).getClientBehaviors()).get("action")) != null && !actionBehaviours.isEmpty()) {
            for (AjaxBehavior actionBehaviour : actionBehaviours) {
                ajaxBehavior = actionBehaviour;
                if (StringUtils.isNotEmpty((String)ajaxBehavior.getOnevent())) {
                    this.onEventCallback = ajaxBehavior.getOnevent();
                }
                ajaxBehavior.setOnevent(this.getOnEventListenerName(component));
            }
        }
        super.renderAsActive(context, component);
        if (ajaxBehavior != null) {
            ajaxBehavior.setOnevent(this.onEventCallback);
        }
    }

    private String getOnEventListenerName(UIComponent component) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return "glyphiconLinkListener_" + component.getClientId().replace(separatorChar + "", "_");
    }

    protected void writeWaitingDotsIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        if (commandLink.isAjaxDisableLinkOnRequest()) {
            writer.startElement("span", (UIComponent)commandLink);
            writer.writeAttribute("class", (Object)"butter-component-glyphicon-processing", null);
            writer.endElement("span");
        }
    }

    protected void writeGlyphiconIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        String glyphicon = commandLink.getGlyphicon();
        if (glyphicon != null && !"".equals(glyphicon)) {
            writer.startElement("span", (UIComponent)commandLink);
            writer.writeAttribute("class", (Object)("butter-component-glyphicon " + glyphicon), null);
            writer.endElement("span");
        }
    }
}

