/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.html.HtmlNumber;
import de.larmic.butterfaces.component.partrenderer.HtmlAttributePartRenderer;
import de.larmic.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.LabelPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.partrenderer.TooltipPartRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.NumberRenderer")
public class NumberRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] INPUT_ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.INPUTTEXT);
    private static final Attribute[] OUTPUT_ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.OUTPUTTEXT);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        new OuterComponentWrapperPartRenderer().renderComponentBegin(htmlComponent, writer);
        new LabelPartRenderer().renderLabel(htmlComponent, writer);
        new InnerComponentWrapperPartRenderer().renderInnerWrapperBegin(htmlComponent, writer);
        new ReadonlyPartRenderer().renderReadonly(htmlComponent, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlNumber htmlComponent = (HtmlNumber)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!htmlComponent.isReadonly()) {
            super.encodeEnd(context, component);
        }
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd((HtmlInputComponent)htmlComponent, writer);
        new TooltipPartRenderer().renderTooltip((HtmlInputComponent)htmlComponent, writer);
        String min = "".equals(htmlComponent.getMin()) ? "0" : htmlComponent.getMin();
        String max = "".equals(htmlComponent.getMax()) ? "100" : htmlComponent.getMax();
        writer.startElement("script", component);
        writer.writeText((Object)("jQuery(document.getElementById('" + component.getClientId() + "')).find('input.butter-number-component').TouchSpin({ verticalbuttons: true });"), null);
        writer.endElement("script");
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (component instanceof UIInput) {
            writer.startElement("input", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
            writer.writeAttribute("type", (Object)"text", null);
            String styleClass = StringUtils.concatWithSpace((String[])new String[]{"butter-input-component", "form-control", "butter-number-component", !((HtmlInputComponent)component).isValid() ? "butter-component-invalid" : null});
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (currentValue != null) {
                writer.writeAttribute("value", (Object)currentValue, "value");
            }
            writer.writeAttribute("autocomplete", (Object)"off", "autocomplete");
            this.renderHtmlFeatures(component, writer);
            RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])INPUT_ATTRIBUTES, (Map)NumberRenderer.getNonOnChangeBehaviors((UIComponent)component));
            RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
            RenderKitUtils.renderOnchange((FacesContext)context, (UIComponent)component, (boolean)false);
            writer.endElement("input");
            if (component instanceof HtmlNumber) {
                HtmlNumber inputComponent = (HtmlNumber)component;
                writer.startElement("script", component);
                writer.writeText((Object)("var _component = document.getElementById('" + component.getClientId() + "');"), null);
                writer.writeText((Object)("_component.addEventListener('keyup', function(e) {handleSpinner(e, _component, " + this.convertMinMax(inputComponent.getMin()) + ", " + this.convertMinMax(inputComponent.getMax()) + ")}, false);"), null);
                writer.endElement("script");
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren = WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AllowTextChildren);
        if (!renderChildren) {
            return;
        }
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }

    protected void renderHtmlFeatures(UIComponent component, ResponseWriter writer) throws IOException {
        if (component instanceof HtmlNumber) {
            HtmlNumber inputComponent = (HtmlNumber)component;
            new HtmlAttributePartRenderer().writePlaceholderAttribute(writer, inputComponent.getPlaceholder());
            if (inputComponent.getAutoFocus()) {
                writer.writeAttribute("autofocus", (Object)"true", null);
            }
        }
    }

    private String convertMinMax(String value) {
        try {
            return "'" + Integer.valueOf(value) + "'";
        }
        catch (NumberFormatException e) {
            return "null";
        }
    }
}

