/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.partrenderer.HtmlAttributePartRenderer;
import de.larmic.butterfaces.component.partrenderer.InnerComponentCheckBoxWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.LabelPartRenderer;
import de.larmic.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import de.larmic.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.component.partrenderer.TooltipPartRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.CheckBoxRenderer")
public class CheckBoxRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.SELECTBOOLEANCHECKBOX);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        super.encodeBegin(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        new OuterComponentWrapperPartRenderer().renderComponentBegin(htmlComponent, writer);
        new LabelPartRenderer().renderLabel(htmlComponent, writer);
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperBegin(htmlComponent, writer);
        new ReadonlyPartRenderer().renderReadonly(htmlComponent, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!htmlComponent.isReadonly()) {
            super.encodeEnd(context, component);
        }
        new InnerComponentCheckBoxWrapperPartRenderer().renderInnerWrapperEnd(htmlComponent, writer);
        new TooltipPartRenderer().renderTooltip(htmlComponent, writer);
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        boolean isChecked = CheckBoxRenderer.isChecked((String)requestParameterMap.get(clientId));
        this.setSubmittedValue(component, isChecked);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new value after decoding: {0}", isChecked);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue instanceof Boolean ? submittedValue : Boolean.valueOf(submittedValue.toString());
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("type", (Object)"checkbox", "type");
        if (Boolean.valueOf(currentValue).booleanValue()) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        if (StringUtils.isNotEmpty((String)(styleClass = StringUtils.concatWithSpace((String[])new String[]{"butter-input-component", !((HtmlInputComponent)component).isValid() ? "butter-component-invalid" : null})))) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderHtmlFeatures(component, writer);
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES, (Map)CheckBoxRenderer.getNonOnClickSelectBehaviors((UIComponent)component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
        RenderKitUtils.renderSelectOnclick((FacesContext)context, (UIComponent)component, (boolean)false);
        writer.endElement("input");
    }

    protected void renderHtmlFeatures(UIComponent component, ResponseWriter writer) throws IOException {
        new HtmlAttributePartRenderer().renderHtmlFeatures(component, writer);
    }

    private static boolean isChecked(String value) {
        return "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }
}

