/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.action;

import de.larmic.butterfaces.component.html.action.HtmlCommandLink;
import de.larmic.butterfaces.resolver.AjaxClientIdResolver;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.component.renderkit.html_basic.commandLinkRenderer")
public class CommandLinkRenderer
extends com.sun.faces.renderkit.html_basic.CommandLinkRenderer {
    private WebXmlParameters webXmlParameters;
    private String onEventCallback = null;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.onEventCallback = null;
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter writer = context.getResponseWriter();
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        if (!link.isDisabled()) {
            super.encodeBegin(context, component);
        } else {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            this.writeCommonLinkAttributes(writer, component);
            if (StringUtils.isNotEmpty((String)link.getStyle())) {
                writer.writeAttribute("style", (Object)link.getStyle(), "style");
            }
            this.writeValue(component, writer);
        }
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        return true;
    }

    protected void writeCommonLinkAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        String styleClass = (String)component.getAttributes().get("styleClass");
        StringBuilder generatedStyleClass = new StringBuilder(StringUtils.isEmpty((String)styleClass) ? "" : styleClass);
        if (link.isDisabled()) {
            generatedStyleClass.append(" btn-disabled");
        }
        if (StringUtils.isEmpty((String)link.getGlyphicon())) {
            generatedStyleClass.append(" no-glyphicon");
        }
        if (generatedStyleClass.length() > 0) {
            writer.writeAttribute("class", (Object)generatedStyleClass.toString(), "styleClass");
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String resetValues = (String)params.get("javax.faces.partial.resetValues");
        String render = (String)params.get("javax.faces.partial.render");
        if (StringUtils.isNotEmpty((String)resetValues) && StringUtils.isNotEmpty((String)render) && Boolean.valueOf(resetValues).booleanValue()) {
            String[] split;
            for (String clientId : split = render.split(" ")) {
                UIComponent renderComponent = context.getViewRoot().findComponent(clientId);
                this.resetValues(renderComponent);
            }
        }
        super.decode(context, component);
    }

    private void resetValues(UIComponent component) {
        if (component == null) {
            return;
        }
        for (UIComponent child : component.getChildren()) {
            this.resetValues(child);
        }
        if (component instanceof UIOutput) {
            ((UIOutput)component).resetValue();
        } else if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).resetValue();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!link.isDisabled()) {
            if (link.isAjaxDisableLinkOnRequest()) {
                writer.startElement("script", component);
                writer.writeText((Object)("function " + this.getOnEventListenerName(component) + "(data) {"), null);
                if (StringUtils.isNotEmpty((String)this.onEventCallback)) {
                    writer.writeText((Object)("    " + this.onEventCallback + "(data);"), null);
                }
                String processingText = this.createAjaxProcessingText(link);
                String processingGlyphicon = this.createAjaxProcessingGlypicon(link);
                AjaxClientIdResolver ajaxClientIdResolver = new AjaxClientIdResolver((UIComponent)link);
                String jQueryIDSelector = link.isAjaxDisableRenderRegionsOnRequest() ? ajaxClientIdResolver.getjQueryRenderIDSelector() : "undefined";
                writer.writeText((Object)this.createDisableOnClickFunctionCall(link, processingText, processingGlyphicon, jQueryIDSelector), null);
                writer.writeText((Object)"}", null);
                writer.endElement("script");
            }
            super.encodeEnd(context, component);
        } else {
            writer.endElement("span");
        }
    }

    private String createDisableOnClickFunctionCall(HtmlCommandLink link, String processingText, String processingGlyphicon, String jQueryIDSelector) {
        StringBuffer sb = new StringBuffer();
        sb.append("    butter.link.disableOnClick(data, ");
        sb.append(link.isAjaxShowWaitingDotsOnRequest()).append(",");
        if (link.getValue() != null) {
            sb.append("'").append(link.getValue()).append("'");
        } else {
            sb.append("null");
        }
        sb.append(",'");
        sb.append(processingText).append("','");
        sb.append(link.getGlyphicon()).append("','");
        sb.append(processingGlyphicon).append("',");
        sb.append(link.isAjaxHideGlyphiconOnRequest()).append(",'");
        sb.append(jQueryIDSelector).append("');");
        return sb.toString();
    }

    private String createAjaxProcessingText(HtmlCommandLink link) {
        if (StringUtils.isNotEmpty((String)link.getAjaxProcessingTextOnRequest())) {
            return link.getAjaxProcessingTextOnRequest();
        }
        return this.webXmlParameters.getAjaxProcessingTextOnRequest();
    }

    private String createAjaxProcessingGlypicon(HtmlCommandLink link) {
        if (StringUtils.isNotEmpty((String)link.getAjaxProcessingGlyphiconOnRequest())) {
            return link.getAjaxProcessingGlyphiconOnRequest();
        }
        return this.webXmlParameters.getAjaxProcessingGlyphiconOnRequest();
    }

    protected void writeValue(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlCommandLink commandLink = (HtmlCommandLink)component;
        this.writeGlyphiconIfNecessary(commandLink, writer);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"butter-component-glyphicon-text", null);
        super.writeValue(component, writer);
        writer.endElement("span");
        this.writeWaitingDotsIfNecessary(commandLink, writer);
    }

    protected void renderAsActive(FacesContext context, UIComponent component) throws IOException {
        AbstractMap behaviors;
        List actionBehaviours;
        AjaxBehavior ajaxBehavior = null;
        if (((HtmlCommandLink)component).isAjaxDisableLinkOnRequest() && (actionBehaviours = (List)(behaviors = (AbstractMap)((ClientBehaviorHolder)component).getClientBehaviors()).get("action")) != null && !actionBehaviours.isEmpty()) {
            for (AjaxBehavior actionBehaviour : actionBehaviours) {
                ajaxBehavior = actionBehaviour;
                if (StringUtils.isNotEmpty((String)ajaxBehavior.getOnevent())) {
                    this.onEventCallback = ajaxBehavior.getOnevent();
                }
                ajaxBehavior.setOnevent(this.getOnEventListenerName(component));
                ajaxBehavior.setOnerror(this.getOnEventListenerName(component));
            }
        }
        super.renderAsActive(context, component);
        if (ajaxBehavior != null) {
            ajaxBehavior.setOnevent(this.onEventCallback);
        }
    }

    private String getOnEventListenerName(UIComponent component) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return "glyphiconLinkListener_" + component.getClientId().replace(separatorChar + "", "_");
    }

    protected void writeWaitingDotsIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        if (commandLink.isAjaxDisableLinkOnRequest()) {
            writer.startElement("span", (UIComponent)commandLink);
            writer.writeAttribute("class", (Object)"butter-component-glyphicon-processing", null);
            writer.endElement("span");
        }
    }

    protected void writeGlyphiconIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        String glyphicon = StringUtils.getNotNullValue((String)commandLink.getGlyphicon(), (String)"");
        writer.startElement("span", (UIComponent)commandLink);
        writer.writeAttribute("class", (Object)("butter-component-glyphicon " + glyphicon), null);
        writer.endElement("span");
    }
}

