/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.mojarra;

import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.html.table.HtmlTable;
import de.larmic.butterfaces.util.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TableRenderer
extends com.sun.faces.renderkit.html_basic.TableRenderer {
    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        info.newRow();
        int columnNumber = 0;
        for (UIColumn column : info.columns) {
            boolean isRowHeader = false;
            Object rowHeaderValue = column.getAttributes().get("rowHeader");
            if (null != rowHeaderValue) {
                isRowHeader = Boolean.valueOf(rowHeaderValue.toString());
            }
            if (isRowHeader) {
                writer.startElement("th", (UIComponent)column);
                writer.writeAttribute("scope", (Object)"row", null);
            } else {
                HtmlColumn htmlColumn;
                writer.startElement("td", (UIComponent)column);
                StringBuilder sb = new StringBuilder("butter-component-table-column");
                if (column instanceof HtmlColumn && StringUtils.isNotEmpty((String)(htmlColumn = (HtmlColumn)column).getStyleClass())) {
                    sb.append(" ").append(htmlColumn.getStyleClass());
                }
                writer.writeAttribute("class", (Object)sb.toString(), null);
                writer.writeAttribute("columnNumber", (Object)("" + columnNumber), null);
                if (column instanceof HtmlColumn && table instanceof HtmlTable && this.isHideColumn((HtmlTable)table, (HtmlColumn)column)) {
                    writer.writeAttribute("style", (Object)"display:none", null);
                } else if (column instanceof HtmlColumn && StringUtils.isNotEmpty((String)(htmlColumn = (HtmlColumn)column).getStyle())) {
                    writer.writeAttribute("style", (Object)htmlColumn.getStyle(), null);
                }
            }
            String columnClass = info.getCurrentColumnClass();
            if (columnClass != null) {
                writer.writeAttribute("class", (Object)columnClass, "columnClasses");
            }
            Iterator gkids = this.getChildren((UIComponent)column);
            while (gkids.hasNext()) {
                this.encodeRecursive(context, (UIComponent)gkids.next());
            }
            if (isRowHeader) {
                writer.endElement("th");
            } else {
                writer.endElement("td");
            }
            writer.writeText((Object)"\n", table, null);
            ++columnNumber;
        }
    }

    private boolean isHideColumn(HtmlTable table, HtmlColumn column) {
        if (table.getTableColumnVisibilityModel() != null) {
            String tableUniqueIdentifier = table.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            Boolean hideColumn = table.getTableColumnVisibilityModel().isColumnHidden(tableUniqueIdentifier, columnUniqueIdentifier);
            if (hideColumn != null) {
                return hideColumn;
            }
        }
        return column.isHideColumn();
    }
}

