/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.openimaj.io.InternalReadable;
import org.openimaj.text.nlp.language.LanguageModel;

public class IOUtils {
    public static <T extends InternalReadable> T newInstance(Class<T> cls) {
        try {
            return (T)((InternalReadable)cls.newInstance());
        }
        catch (Exception e) {
            try {
                Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
                if (constr != null) {
                    constr.setAccessible(true);
                    return (T)((InternalReadable)constr.newInstance(new Object[0]));
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
    }

    static <T extends InternalReadable> T newInstance(String className) {
        try {
            return (T)IOUtils.newInstance(Class.forName(className));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends LanguageModel> T read(InputStream fis, T obj) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(fis);
        if (IOUtils.isBinary(bis, obj.binaryHeader())) {
            byte[] header = new byte[obj.binaryHeader().length];
            bis.read(header, 0, header.length);
            obj.readBinary(new DataInputStream(bis));
            return obj;
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isBinary(BufferedInputStream bis, byte[] header) throws IOException {
        bis.mark(header.length + 10);
        byte[] aheader = new byte[header.length];
        bis.read(aheader, 0, aheader.length);
        bis.reset();
        return Arrays.equals(aheader, header);
    }
}

