/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mediawiki.actions.misc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.contentRep.ParsedPage;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.JsonMapper;
import net.sourceforge.jwbf.mapper.MediawikiModule;
import net.sourceforge.jwbf.mediawiki.ApiRequestBuilder;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.MWAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsePage
extends MWAction {
    private static final Logger log = LoggerFactory.getLogger(ParsePage.class);
    private static final JsonMapper MAPPER = new JsonMapper(new JsonMapper.ToJsonFunction(){
        private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new MediawikiModule());

        public Object toJson(String jsonString, Class<?> clazz) {
            try {
                return this.mapper.readValue(jsonString, clazz);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private final boolean followRedirects;
    private final Optional<String> language;
    private final String page;
    private final Set<ParseProp> props;
    private final Optional<Integer> section;
    private final MediaWiki.Version version;
    private ParsedPage parsedPage;

    public ParsePage(String page, Set<ParseProp> props, boolean followRedirects, Integer section, String language, MediaWiki.Version version) {
        this.version = version;
        this.page = Checked.nonBlank((String)page, (String)"page");
        this.props = (Set)Checked.nonNull(props, (String)"page props");
        this.followRedirects = followRedirects;
        this.section = Optional.fromNullable((Object)section);
        this.language = Optional.fromNullable((Object)language);
    }

    public ParsePage(String page, Set<ParseProp> props, boolean followRedirects, MediaWiki.Version version) {
        this(page, props, followRedirects, null, null, version);
    }

    public HttpAction getNextMessage() {
        RequestBuilder requestBuilder = new ApiRequestBuilder().action("parse").formatJson().param("page", MediaWiki.urlEncode((String)this.page)).param("prop", MediaWiki.urlEncode((String)Joiner.on((String)"|").join(this.props))).param("redirects", this.followRedirects).param(this.version.greaterEqThen(MediaWiki.Version.DEVELOPMENT) ? "disablelimitreport" : "disablepp", true);
        if (this.section.isPresent()) {
            requestBuilder.param("section", ((Integer)this.section.get()).intValue());
        }
        if (this.language.isPresent()) {
            requestBuilder.param("uselang", (String)this.language.get());
        }
        return requestBuilder.buildGet();
    }

    public ParsedPage getResult() {
        return this.parsedPage;
    }

    public String processReturningText(String s, HttpAction hm) {
        this.parsedPage = ParsePage.parse(s);
        return null;
    }

    @VisibleForTesting
    static ParsedPage parse(String s) {
        ParsedPageWrapper wrapper = (ParsedPageWrapper)MAPPER.get(s, ParsedPageWrapper.class);
        if (wrapper.warnings != null && !wrapper.warnings.isEmpty()) {
            log.info("Got warning: '{}'", wrapper.warnings);
        }
        return wrapper.parse;
    }

    private static final class ParsedPageWrapper {
        @JsonProperty
        ParsedPage parse;
        @JsonProperty
        Map<String, Map<String, String>> warnings;

        private ParsedPageWrapper() {
        }
    }

    public static enum ParseProp {
        categories,
        categorieshtml,
        displaytitle,
        externallinks,
        headhtml,
        headitems,
        images,
        iwlinks,
        langlinks,
        languageshtml,
        limitreporthtml,
        links,
        modules,
        revid,
        sections,
        templates,
        text;

    }
}

