/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.contentRep;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParsedPage {
    private String title;
    private String pageId;
    private long revId;
    private String text;
    private List<LangLink> langLinks;
    private List<Category> categories;
    private List<Link> links;
    private List<Link> templates;
    private List<String> images;
    private List<String> externalLinks;
    private List<Section> sections;
    private String displayTitle;
    @JsonProperty(value="iwlinks")
    private Collection<InterWikiLink> interWikiLinks;
    private Map<String, String> properties;
    private List<Redirect> redirects;

    public String getTitle() {
        return this.title;
    }

    public String getPageId() {
        return this.pageId;
    }

    public long getRevId() {
        return this.revId;
    }

    public String getText() {
        return this.text;
    }

    public List<LangLink> getLangLinks() {
        return this.langLinks;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public List<Link> getTemplates() {
        return this.templates;
    }

    public List<String> getImages() {
        return this.images;
    }

    public List<String> getExternalLinks() {
        return this.externalLinks;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public Collection<InterWikiLink> getInterWikiLinks() {
        return this.interWikiLinks;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Redirect> getRedirects() {
        return this.redirects;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    void setRevId(long revId) {
        this.revId = revId;
    }

    @JsonProperty
    void setText(ParsedText text) {
        this.text = text.text;
    }

    void setLangLinks(List<LangLink> langLinks) {
        this.langLinks = langLinks;
    }

    void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    void setLinks(List<Link> links) {
        this.links = links;
    }

    void setTemplates(List<Link> templates) {
        this.templates = templates;
    }

    void setImages(List<String> images) {
        this.images = images;
    }

    void setExternalLinks(List<String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    void setSections(List<Section> sections) {
        this.sections = sections;
    }

    void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    void setInterWikiLinks(Collection<InterWikiLink> interWikiLinks) {
        this.interWikiLinks = interWikiLinks;
    }

    @JsonProperty
    void setProperties(List<Map<String, String>> properties) {
        this.properties = ParsedPage.convertProperties(properties);
    }

    private static Map<String, String> convertProperties(List<Map<String, String>> properties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map<String, String> kv : properties) {
            builder.put((Object)kv.get("name"), (Object)kv.get("*"));
        }
        return builder.build();
    }

    public void setRedirects(List<Redirect> redirects) {
        this.redirects = redirects;
    }

    @JsonNaming(value=PropertyNamingStrategy.LowerCaseStrategy.class)
    public static class LangLink {
        private Locale lang;
        private String url;
        private String langName;
        private String autonym;
        @JsonProperty(value="*")
        private String pageName;

        public Locale getLang() {
            return this.lang;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLangName() {
            return this.langName;
        }

        public String getAutonym() {
            return this.autonym;
        }

        public String getPageName() {
            return this.pageName;
        }

        void setLang(Locale lang) {
            this.lang = lang;
        }

        void setUrl(String url) {
            this.url = url;
        }

        void setLangName(String langName) {
            this.langName = langName;
        }

        void setAutonym(String autonym) {
            this.autonym = autonym;
        }

        void setPageName(String pageName) {
            this.pageName = pageName;
        }
    }

    public static class Category {
        private String sortkey;
        @JsonProperty(value="*")
        private String name;
        private boolean hidden;

        public String getSortkey() {
            return this.sortkey;
        }

        public String getName() {
            return this.name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        void setSortkey(String sortkey) {
            this.sortkey = sortkey;
        }

        void setName(String name) {
            this.name = name;
        }

        void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }

    public static class Link {
        @JsonProperty(value="ns")
        int namespace;
        @JsonProperty(value="*")
        String name;
        @JsonProperty
        boolean exists;

        public int getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists() {
            return this.exists;
        }
    }

    public static class Section {
        @JsonProperty
        int tocLevel;
        @JsonProperty
        int level;
        @JsonProperty
        String line;
        @JsonProperty
        String number;
        @JsonProperty
        int index;
        @JsonProperty
        String fromtitle;
        @JsonProperty
        long byteOffset;
        @JsonProperty
        String anchor;

        public int getTocLevel() {
            return this.tocLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public String getLine() {
            return this.line;
        }

        public String getNumber() {
            return this.number;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFromtitle() {
            return this.fromtitle;
        }

        public long getByteOffset() {
            return this.byteOffset;
        }

        public String getAnchor() {
            return this.anchor;
        }
    }

    public static class InterWikiLink {
        @JsonProperty
        String prefix;
        @JsonProperty
        String url;
        @JsonProperty(value="*")
        String name;

        public String getPrefix() {
            return this.prefix;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }
    }

    static class ParsedText {
        @JsonProperty(value="*")
        String text;

        ParsedText() {
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Redirect {
        @JsonProperty
        public String from;
        @JsonProperty
        public String to;
        @JsonProperty
        public String tofragment;

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getToFragment() {
            return this.tofragment;
        }
    }
}

