/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.FormURLEncodedParser;
import io.mola.galimatias.NameValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class URLSearchParameters
implements Iterable<NameValue> {
    private static final List<NameValue> EMPTY_NAME_VALUES = Collections.unmodifiableList(new ArrayList(0));
    private final List<NameValue> nameValues;

    public URLSearchParameters(String query) {
        this.nameValues = query != null && !query.isEmpty() ? Collections.unmodifiableList(FormURLEncodedParser.parse(query)) : EMPTY_NAME_VALUES;
    }

    URLSearchParameters(List<NameValue> nameValues) {
        if (nameValues == null) {
            throw new NullPointerException("nameValues");
        }
        this.nameValues = Collections.unmodifiableList(nameValues);
    }

    public URLSearchParameters withAppended(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.withAppended(new NameValue(name, value));
    }

    public URLSearchParameters withAppended(NameValue nameValue) {
        if (nameValue == null) {
            throw new NullPointerException("nameValue");
        }
        ArrayList<NameValue> newNameValuesList = new ArrayList<NameValue>(this.nameValues.size() + 1);
        for (NameValue nv : this.nameValues) {
            newNameValuesList.add(nv);
        }
        newNameValuesList.add(nameValue);
        return new URLSearchParameters(newNameValuesList);
    }

    public URLSearchParameters with(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.with(new NameValue(name, value));
    }

    public URLSearchParameters with(NameValue nameValue) {
        if (nameValue == null) {
            throw new NullPointerException("nameValue");
        }
        ArrayList<NameValue> newNameValuesList = new ArrayList<NameValue>(this.nameValues.size() + 1);
        String name = nameValue.name();
        for (NameValue nv : this.nameValues) {
            if (nv.name().equals(name)) continue;
            newNameValuesList.add(nv);
        }
        newNameValuesList.add(nameValue);
        return new URLSearchParameters(newNameValuesList);
    }

    public URLSearchParameters without(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<NameValue> newNameValuesList = new ArrayList<NameValue>(this.nameValues.size());
        for (NameValue nv : this.nameValues) {
            if (nv.name().equals(name)) continue;
            newNameValuesList.add(nv);
        }
        return new URLSearchParameters(newNameValuesList);
    }

    public String get(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (NameValue nv : this.nameValues) {
            if (!name.equals(nv.name())) continue;
            return nv.value();
        }
        return null;
    }

    public List<String> getAll(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (NameValue nv : this.nameValues) {
            if (!name.equals(nv.name())) continue;
            result.add(nv.value());
        }
        return result;
    }

    public boolean has(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (NameValue nv : this.nameValues) {
            if (!name.equals(nv.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<NameValue> iterator() {
        return this.nameValues.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLSearchParameters that = (URLSearchParameters)o;
        return this.nameValues.equals(that.nameValues);
    }

    public int hashCode() {
        return this.nameValues.hashCode();
    }
}

