/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final ImmutableMap<String, Integer> MONTH_MAPPINGS = ImmutableMap.builder().put((Object)"jan", (Object)1).put((Object)"feb", (Object)2).put((Object)"mar", (Object)3).put((Object)"apr", (Object)4).put((Object)"may", (Object)5).put((Object)"jun", (Object)6).put((Object)"jul", (Object)7).put((Object)"aug", (Object)8).put((Object)"sep", (Object)9).put((Object)"oct", (Object)10).put((Object)"nov", (Object)11).put((Object)"dec", (Object)12).put((Object)"january", (Object)1).put((Object)"february", (Object)2).put((Object)"march", (Object)3).put((Object)"april", (Object)4).put((Object)"june", (Object)6).put((Object)"july", (Object)7).put((Object)"august", (Object)8).put((Object)"september", (Object)9).put((Object)"october", (Object)10).put((Object)"november", (Object)11).put((Object)"december", (Object)12).build();
    private static final Set<ZoneId> PREFERRED_ZONES = ImmutableSet.of((Object)ZoneId.of("Europe/London", Collections.singletonMap("BST", "Europe/London")), (Object)ZoneId.of("Europe/Berlin", (Map<String, String>)ImmutableMap.of((Object)"CET", (Object)"Europe/Berlin", (Object)"MEZ", (Object)"Europe/Berlin")));
    private static final Set<String> META_DATE_KEYS = ImmutableSet.of((Object)"article:published_time", (Object)"datepublished", (Object)"og:updated_time", (Object)"last-modified", (Object)"article:modified_time", (Object)"date", (Object[])new String[]{"datemodified", "pubdate", "og:modified_time", "lastmod", "dc.date", "modified"});
    public static final List<String> META_ATTRIBUTE_NAMES = ImmutableList.of((Object)"name", (Object)"http-equiv", (Object)"property", (Object)"itemprop");
    private static final int FIRST_YEAR = 1990;
    private static final List<DateTimeFormatter> FORMATS = ImmutableList.of((Object)DateTimeFormatter.ISO_DATE_TIME, (Object)DateUtils.withTimeZoneShortName(DateTimeFormatter.ISO_DATE_TIME), (Object)DateUtils.withTimeZoneShortName(DateTimeFormatter.ofPattern("y-M-d' 'H:m:s ")), (Object)DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(Locale.getDefault()), (Object)DateUtils.withTimeZoneShortName(DateTimeFormatter.ofPattern("EEE, d MMM y H:m:s ")).withLocale(Locale.ENGLISH), (Object)DateTimeFormatter.ofPattern("E, d MMM y H:m:s Z").withLocale(Locale.ENGLISH), (Object)DateTimeFormatter.ofPattern("MMM dd, YYYY h:m a").withLocale(Locale.ENGLISH), (Object)DateTimeFormatter.ofPattern("YY/d/M"), (Object)DateTimeFormatter.ofPattern("YY/M/d"), (Object)DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss"), (Object)DateTimeFormatter.ofPattern("MM/dd/YYYY"), (Object)DateTimeFormatter.ofPattern("MMM. dd, YYYY, hh:mm a").withLocale(Locale.ENGLISH), (Object[])new DateTimeFormatter[]{DateUtils.withTimeZoneShortName(DateTimeFormatter.ofPattern("MM/dd/YYYY HH:mm:ss ")), DateUtils.withTimeZoneShortName(DateTimeFormatter.ofPattern("EEE, MMM d, YYYY H:m ")).withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("d MMM y").withLocale(Locale.forLanguageTag("ru")), DateUtils.withTimeZoneShortName(DateTimeFormatter.ofPattern("y-M-d'@'H:m:s ")), DateTimeFormatter.ofPattern("YYYY-MM-dd hh:mm:ss a Z"), DateTimeFormatter.ofPattern("yyyy-M-d'T'HH:mm:ssXXX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxx"), DateTimeFormatter.ISO_DATE, DateTimeFormatter.ofPattern("YYYYMMdd"), DateTimeFormatter.ofPattern("dd.MM.yyyy"), DateTimeFormatter.ofPattern("ccc, dd LLL yyyy HH:mm:ss zZZ", Locale.GERMAN)});
    private static final int LAST_YEAR = Calendar.getInstance().get(1);
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static final Splitter URL_SEGMENT_SPLITTER = Splitter.onPattern((String)"[-/_.]").omitEmptyStrings();
    public static final ZonedDateTime CUTOFF_DATE = ZonedDateTime.of(1990, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);

    private DateUtils() {
    }

    public static LocalDate extractDate(String path) {
        CharMatcher charMatcher = CharMatcher.inRange((char)'0', (char)'9');
        DateParse parse = new DateParse();
        for (String segment : URL_SEGMENT_SPLITTER.split((CharSequence)path)) {
            if (charMatcher.matchesAllOf((CharSequence)segment)) {
                parse.tryParseDigitsSegment(path, segment);
                continue;
            }
            if (!MONTH_MAPPINGS.containsKey((Object)segment.toLowerCase(Locale.ENGLISH))) continue;
            parse.tryParseFullMonth(segment);
        }
        if (parse.isFullySpecified()) {
            try {
                return parse.toLocalDate();
            }
            catch (IllegalArgumentException e) {
                logger.trace("Not a valid date {} in '{}'", (Object)parse, (Object)path);
            }
        }
        return null;
    }

    public static LocalDate extractDateFromUrl(String url) {
        try {
            return DateUtils.extractDate(new URL(url).getPath());
        }
        catch (MalformedURLException e) {
            logger.debug("Malformed URL  '{}'", (Object)url);
            return null;
        }
    }

    public static ZonedDateTime liberalParseDate(String dateCandidate) {
        if (dateCandidate == null || dateCandidate.isEmpty()) {
            return null;
        }
        String normalized = DateUtils.normalizeHalfDay(dateCandidate);
        for (DateTimeFormatter formatter : FORMATS) {
            try {
                ZonedDateTime date;
                TemporalAccessor parsed = formatter.parseBest(normalized, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
                logger.trace("'{}' parsed to {}", (Object)dateCandidate, (Object)parsed);
                if (parsed instanceof ZonedDateTime) {
                    date = (ZonedDateTime)parsed;
                } else if (parsed instanceof LocalDateTime) {
                    date = ((LocalDateTime)parsed).atZone(ZoneOffset.UTC);
                } else if (parsed instanceof LocalDate) {
                    date = ((LocalDate)parsed).atStartOfDay(ZoneOffset.UTC);
                } else {
                    throw new IllegalStateException();
                }
                if (date.isBefore(CUTOFF_DATE) || date.isAfter(ZonedDateTime.now())) {
                    throw new IllegalArgumentException("Date out of range: " + parsed);
                }
                return date;
            }
            catch (DateTimeParseException e) {
                logger.trace("Could not parse date: {}: {}", (Object)dateCandidate, (Object)e.getMessage());
            }
        }
        return null;
    }

    private static String normalizeHalfDay(String dateCandidate) {
        String normalized = dateCandidate.replaceAll("[aA]\\.?\\s*[mM]\\.?", "AM").replaceAll("[pP]\\.?\\s*[mM]\\.?", "PM");
        if (!dateCandidate.equals(normalized)) {
            logger.debug("normalized '{}' to '{}'", (Object)dateCandidate, (Object)normalized);
        }
        return normalized;
    }

    private static DateTimeFormatter withTimeZoneShortName(DateTimeFormatter formatter) {
        return new DateTimeFormatterBuilder().append(formatter).appendZoneText(TextStyle.SHORT, PREFERRED_ZONES).toFormatter();
    }

    public static boolean dateMetaKey(String key) {
        if (key == null) {
            return false;
        }
        return META_DATE_KEYS.contains(key.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isValidDate(ZonedDateTime date) {
        return date.isAfter(CUTOFF_DATE) && date.isBefore(ZonedDateTime.now());
    }

    static class DateParse {
        int year = -1;
        int month = -1;
        int day = -1;
        boolean canOverrideDay = false;
        boolean canOverrideMonth = false;

        DateParse() {
        }

        void tryParseFullDate(String segment) {
            if (this.year < 0) {
                int yearCandidate = Integer.parseInt(segment.substring(0, 4));
                if (1990 <= yearCandidate && yearCandidate <= yearCandidate) {
                    this.year = yearCandidate;
                    this.month = Integer.parseInt(segment.substring(4, 6));
                    this.day = Integer.parseInt(segment.substring(6));
                } else {
                    logger.debug("Ignoring possible date '{}' because it is out of the expected date range", (Object)segment);
                }
            }
        }

        void tryParseYear(String segment) {
            int candidate = Integer.parseInt(segment);
            if (1990 <= candidate && candidate <= LAST_YEAR) {
                this.year = candidate;
            }
        }

        void tryParseMonthDay(String fullString, String segment) {
            int candidate = Integer.parseInt(segment);
            if (candidate > 12 && candidate <= 31 && this.day < 0) {
                this.day = candidate;
            } else if (candidate > 0) {
                this.tryAssignMonthOrDay(candidate);
            } else {
                logger.trace("Could not decide on '{}' in '{}'", (Object)candidate, (Object)fullString);
            }
        }

        private void tryAssignMonthOrDay(int candidate) {
            if (this.month >= 0 && this.canOverrideMonth) {
                this.month = candidate;
                this.day = candidate;
                this.canOverrideDay = true;
                this.canOverrideMonth = false;
            } else if (this.month >= 0) {
                if (this.day < 0 || this.canOverrideDay) {
                    this.day = candidate;
                    this.canOverrideDay = this.day == this.month;
                }
            } else if (this.month < 0 || this.canOverrideMonth) {
                this.month = candidate;
                this.canOverrideMonth = this.year < 0;
            }
        }

        public LocalDate toLocalDate() {
            return LocalDate.of(this.year, this.month, this.day);
        }

        public String toString() {
            return String.format("%4d-%2d-%2d", this.year, this.month, this.day);
        }

        void tryParseFullMonth(String segment) {
            if (this.month < 0) {
                this.month = (Integer)MONTH_MAPPINGS.get((Object)segment.toLowerCase(Locale.ENGLISH));
            }
        }

        boolean isFullySpecified() {
            return this.year > 0 && this.month > 0 && this.day > 0;
        }

        private void tryParseDigitsSegment(String path, String segment) {
            if (segment.length() == 8) {
                this.tryParseFullDate(segment);
            } else if (segment.length() == 4) {
                this.tryParseYear(segment);
            } else if (segment.length() == 2 || segment.length() == 1) {
                this.tryParseMonthDay(path, segment);
            }
        }
    }
}

