/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.snapshots;

import java.time.ZonedDateTime;
import java.util.Objects;

public class SnaphotLocation {
    private final String url;
    private final ZonedDateTime crawlTime;
    private final String warcFile;
    private final long warcFileOffset;
    private final long length;
    private final String mimeType;
    private final String signature;

    public SnaphotLocation(String url, ZonedDateTime crawlTime, String warcFile, long warcFileOffset, long length, String mimeType, String signature) {
        this.url = url;
        this.crawlTime = crawlTime;
        this.warcFile = warcFile;
        this.warcFileOffset = warcFileOffset;
        this.length = length;
        this.mimeType = mimeType;
        this.signature = signature;
    }

    public String getUrl() {
        return this.url;
    }

    public ZonedDateTime getCrawlTime() {
        return this.crawlTime;
    }

    public String getWarcFile() {
        return this.warcFile;
    }

    public long getWarcFileOffset() {
        return this.warcFileOffset;
    }

    public long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SnaphotLocation)) {
            return false;
        }
        SnaphotLocation o = (SnaphotLocation)obj;
        return Objects.equals(this.url, o.url) && Objects.equals(this.crawlTime, o.crawlTime) && Objects.equals(this.warcFile, o.warcFile) && Objects.equals(this.warcFileOffset, o.warcFileOffset) && Objects.equals(this.length, o.length) && Objects.equals(this.mimeType, o.mimeType) && Objects.equals(this.signature, o.signature);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.crawlTime, this.warcFile, this.warcFileOffset, this.length, this.mimeType, this.signature);
    }

    public String toString() {
        return String.format("%s@%s (%s:%d+%d)", this.url, this.crawlTime, this.warcFile, this.warcFileOffset, this.length);
    }

    public SnaphotLocation withWarcFile(String newWarcFile) {
        return new SnaphotLocation(this.url, this.crawlTime, newWarcFile, this.warcFileOffset, this.length, this.mimeType, this.signature);
    }
}

