/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.snapshots;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import de.l3s.icrawl.snapshots.SnaphotLocation;
import de.l3s.icrawl.snapshots.SnapshotReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveReaderFactory;

public class HdfsSnapshotReader
implements SnapshotReader {
    private final FileSystem fs;
    private final Meter recordRate;
    private final Timer timer;

    public HdfsSnapshotReader(Configuration conf, MetricRegistry metrics) throws IOException {
        this.fs = FileSystem.get((Configuration)conf);
        this.recordRate = metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"records"}));
        this.timer = metrics.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"ioTime"}));
    }

    @Override
    public ArchiveReader open(SnaphotLocation location) throws IOException {
        try (Timer.Context context = this.timer.time();){
            this.recordRate.mark();
            FSDataInputStream is = this.fs.open(new Path(location.getWarcFile()));
            is.seek(location.getWarcFileOffset());
            ArchiveReader archiveReader = ArchiveReaderFactory.get((String)location.getWarcFile(), (InputStream)is, (boolean)false);
            return archiveReader;
        }
    }
}

