/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.snapshots;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Lists;
import de.l3s.icrawl.snapshots.BaseSnapshotsLocator;
import de.l3s.icrawl.snapshots.SnaphotLocation;
import de.l3s.icrawl.snapshots.SnapshotsLocator;
import de.l3s.icrawl.snapshots.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.archive.url.URLKeyMaker;
import org.archive.url.WaybackURLKeyMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSnapshotsLocator
extends BaseSnapshotsLocator
implements SnapshotsLocator,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HBaseSnapshotsLocator.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)"CDX2");
    private static final byte[] FAMILY = Bytes.toBytes((String)"c");
    private static final byte[] COL_OFFSET = Bytes.toBytes((String)"offset");
    private static final byte[] COL_CRAWL_TIME = Bytes.toBytes((String)"ts");
    private static final byte[] COL_MIME = Bytes.toBytes((String)"mime");
    private static final byte[] COL_ORIGINAL_URL = Bytes.toBytes((String)"origurl");
    private static final byte[] COL_WARC_FILE = Bytes.toBytes((String)"filename");
    private final Connection connection;

    public HBaseSnapshotsLocator(Configuration conf, MetricRegistry metrics) throws IOException {
        this(conf, (URLKeyMaker)new WaybackURLKeyMaker(), metrics);
    }

    public HBaseSnapshotsLocator(Configuration conf, URLKeyMaker keyMaker, MetricRegistry metrics) throws IOException {
        super(keyMaker, metrics);
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
    }

    @Override
    protected Optional<SnaphotLocation> findOneInternal(String surt, ZonedDateTime crawlTime) throws IOException {
        Get get = new Get(Bytes.toBytes((String)surt));
        byte[] tsBytes = Bytes.toBytes((String)Utils.toString(crawlTime));
        get.setFilter((Filter)new SingleColumnValueFilter(FAMILY, COL_CRAWL_TIME, CompareFilter.CompareOp.EQUAL, tsBytes));
        try (Table table = this.connection.getTable(TABLE_NAME);){
            long warcFileOffset;
            Result result = table.get(get);
            if (result.isEmpty()) {
                Optional<SnaphotLocation> optional = Optional.empty();
                return optional;
            }
            String originalUrl = this.getString(result, FAMILY, COL_ORIGINAL_URL);
            String warcFile = this.getString(result, FAMILY, COL_WARC_FILE);
            String offset = this.getString(result, FAMILY, COL_OFFSET);
            try {
                warcFileOffset = Long.parseLong(offset);
            }
            catch (NumberFormatException e) {
                logger.info("Not a valid offset: {}", (Object)offset);
                warcFileOffset = -1L;
            }
            long length = -1L;
            String mimeType = this.getString(result, FAMILY, COL_MIME);
            String signature = null;
            SnaphotLocation sl = new SnaphotLocation(originalUrl, crawlTime, warcFile, warcFileOffset, length, mimeType, signature);
            Optional<SnaphotLocation> optional = Optional.of(sl);
            return optional;
        }
    }

    private String getString(Result result, byte[] family, byte[] qualifier) {
        return this.getString(result.getColumnLatestCell(family, qualifier));
    }

    @Override
    protected List<SnaphotLocation> findInternal(String surt) throws IOException {
        Get get = new Get(Bytes.toBytes((String)surt));
        get.setMaxVersions();
        try (Table table = this.connection.getTable(TABLE_NAME);){
            Result result = table.get(get);
            Map<Long, String> originalUrls = this.getValuesByVersion(result, FAMILY, COL_ORIGINAL_URL);
            Map<Long, String> crawlTimes = this.getValuesByVersion(result, FAMILY, COL_CRAWL_TIME);
            Map<Long, String> warcFiles = this.getValuesByVersion(result, FAMILY, COL_WARC_FILE);
            Map<Long, String> offsets = this.getValuesByVersion(result, FAMILY, COL_OFFSET);
            Map<Long, String> mimeTypes = this.getValuesByVersion(result, FAMILY, COL_MIME);
            ArrayList results = Lists.newArrayListWithExpectedSize((int)originalUrls.size());
            for (Long version : originalUrls.keySet()) {
                Optional<ZonedDateTime> crawlTime = Utils.parseTimestamp(crawlTimes.get(version));
                if (!crawlTime.isPresent()) {
                    logger.info("No valid date for URL '{}'", (Object)surt);
                }
                String originalUrl = originalUrls.get(version);
                String warcFile = warcFiles.get(version);
                long warcFileOffset = Long.parseLong(offsets.get(version));
                long length = -1L;
                String mimeType = mimeTypes.get(version);
                String signature = null;
                results.add(new SnaphotLocation(originalUrl, crawlTime.orElse(null), warcFile, warcFileOffset, length, mimeType, signature));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
    }

    private Map<Long, String> getValuesByVersion(Result result, byte[] family, byte[] qualifier) {
        HashMap<Long, String> values = new HashMap<Long, String>();
        for (Cell cell : result.getColumnCells(family, qualifier)) {
            values.put(cell.getTimestamp(), this.getString(cell));
        }
        return values;
    }

    private String getString(Cell cell) {
        return Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }
}

