/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.snapshots;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import de.l3s.icrawl.snapshots.SnaphotLocation;
import de.l3s.icrawl.snapshots.SnapshotsLocator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.archive.url.URLKeyMaker;
import org.archive.util.io.RuntimeIOException;

public abstract class BaseSnapshotsLocator
implements SnapshotsLocator {
    private final URLKeyMaker keyMaker;
    private final Meter urlRate;
    private final Histogram snapshots;
    private final Timer timer;

    public BaseSnapshotsLocator(URLKeyMaker keyMaker, MetricRegistry metrics) {
        this.keyMaker = keyMaker;
        this.urlRate = metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"urls"}));
        this.snapshots = metrics.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"snapshots"}));
        this.timer = metrics.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"ioTime"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<SnaphotLocation> findLocations(String url) {
        String surt = this.makeSurt(url);
        try (Timer.Context context = this.timer.time();){
            List<SnaphotLocation> result = this.findInternal(surt);
            this.urlRate.mark();
            this.snapshots.update(result.size());
            List<SnaphotLocation> list = result;
            return list;
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SnaphotLocation> findLocation(String url, ZonedDateTime crawlTime) {
        String surt = this.makeSurt(url);
        try (Timer.Context context = this.timer.time();){
            Optional<SnaphotLocation> result = this.findOneInternal(surt, crawlTime);
            this.urlRate.mark();
            this.snapshots.update(result.isPresent() ? 1 : 0);
            Optional<SnaphotLocation> optional = result;
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected abstract List<SnaphotLocation> findInternal(String var1) throws IOException;

    protected abstract Optional<SnaphotLocation> findOneInternal(String var1, ZonedDateTime var2) throws IOException;

    private String makeSurt(String url) {
        try {
            return this.keyMaker.makeKey(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Not a valid URL: " + url, e);
        }
    }
}

