/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.snapshots;

import com.google.common.io.ByteStreams;
import de.l3s.icrawl.snapshots.OnlyHtmlCharsetDetector;
import de.l3s.icrawl.snapshots.Snapshot;
import de.l3s.icrawl.snapshots.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.archive.format.http.HttpHeaders;
import org.archive.format.http.HttpResponse;
import org.archive.format.http.HttpResponseParser;
import org.archive.format.text.charset.CharsetDetector;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.arc.ARCRecordMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveRecordParser {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveRecordParser.class);
    private final HttpResponseParser responseParser = new HttpResponseParser();
    private final CharsetDetector charsetDetector = new OnlyHtmlCharsetDetector();

    public Snapshot readSnapshot(ArchiveRecord archiveRecord) throws IOException {
        Object content;
        ArchiveRecordHeader header = archiveRecord.getHeader();
        String originalUrl = header.getUrl();
        HttpResponse response = this.responseParser.parse((InputStream)archiveRecord);
        HttpHeaders headers = response.getHeaders();
        ZonedDateTime timestamp = this.getCrawlTime(header).orElseGet(() -> this.serverDate(headers));
        byte[] contentBuffer = ByteStreams.toByteArray((InputStream)response.getInner());
        String mimetype = headers.getValue("Content-Type");
        if (mimetype == null) {
            mimetype = header.getMimetype();
        }
        if (mimetype != null && mimetype.startsWith("text")) {
            String charset = this.charsetDetector.getCharset(contentBuffer, contentBuffer.length, headers);
            content = new String(contentBuffer, charset);
        } else {
            content = contentBuffer;
        }
        int status = response.getMessage().getStatus();
        return new Snapshot(originalUrl, timestamp, status, mimetype, Utils.asMap(headers), content);
    }

    private ZonedDateTime serverDate(HttpHeaders headers) {
        String value = null;
        try {
            value = headers.getValueCaseInsensitive("Date");
            Date date = DateUtil.parseDate((String)value);
            return ZonedDateTime.from(date.toInstant());
        }
        catch (DateParseException e) {
            logger.debug("Could not parse HTTP Date header '{}':", (Object)value, (Object)e);
            return null;
        }
    }

    Optional<ZonedDateTime> getCrawlTime(ArchiveRecordHeader header) {
        if (header instanceof ARCRecordMetaData) {
            String date = ((ARCRecordMetaData)header).getDate();
            return Utils.parseTimestamp(date);
        }
        String date = (String)header.getHeaderValue("WARC-Date");
        return Optional.of(ZonedDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME));
    }
}

