/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.domain.specification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamedEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final Set<Label> labels;

    public NamedEntity(Type type, String label) {
        this.type = type;
        this.labels = new HashSet<Label>();
        this.labels.add(new Label(label, null));
    }

    @JsonCreator
    public NamedEntity(@JsonProperty(value="type") Type type, @JsonProperty(value="labels") Set<Label> labels) {
        this.type = type;
        this.labels = labels;
    }

    public NamedEntity(Type type, Label ... labels) {
        this.type = type;
        this.labels = Sets.newHashSet((Object[])labels);
    }

    public Type getType() {
        return this.type;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public void addLabel(String name, Locale language) {
        this.labels.add(new Label(name, language));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.labels});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedEntity other = (NamedEntity)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.labels, other.labels);
    }

    public String toString() {
        return String.format("%s[%s]", new Object[]{this.type, this.labels});
    }

    public static class Label
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final String name;
        @Nullable
        private final Locale language;

        @JsonCreator
        public Label(@Nonnull @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="language") Locale language) {
            this.name = Objects.requireNonNull(name);
            this.language = language;
        }

        public String getName() {
            return this.name;
        }

        public Locale getLanguage() {
            return this.language;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.language);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Label other = (Label)obj;
            return Objects.equals(this.language, other.language) && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return String.format("%s:%s", this.name, this.language);
        }
    }

    public static enum Type {
        PERSON,
        ORGANIZATION,
        LOCATION;

    }
}

