/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.google.common.collect.ImmutableMap;
import de.l3s.icrawl.crawler.yarn.BaseClient;
import de.l3s.icrawl.crawler.yarn.EvaluationAppMaster;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;

public class EvaluationClient
extends BaseClient {
    private Path hdfsSpecPath;
    private String hdfsJarPath;
    private String localSpecArchive;
    private String outputDir;
    private Optional<String> numUrls;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new EvaluationClient(), (String[])args);
    }

    @Override
    protected void configure(String[] args) {
        if (!this.checkUsage(args)) {
            throw new IllegalArgumentException();
        }
        this.hdfsJarPath = args[0];
        this.localSpecArchive = args[1];
        this.outputDir = args[2];
        this.numUrls = args.length > 3 ? Optional.of(args[3]) : Optional.empty();
    }

    @Override
    protected void cleanup() throws IOException {
        this.hdfsSpecPath.getFileSystem(this.getConf()).delete(this.hdfsSpecPath, false);
    }

    @Override
    protected void prepare() throws IOException {
        this.hdfsSpecPath = EvaluationClient.uploadTempFile(new Path(this.localSpecArchive), this.getConf(), "specs-", "zip");
    }

    @Override
    protected boolean checkUsage(String[] args) {
        if (args.length >= 3) {
            return true;
        }
        System.err.println("Usage: java " + EvaluationClient.class.getName() + " hdfsJarPath localSpecArchive outputDir [numUrls]");
        return false;
    }

    @Override
    protected void addParameters(ImmutableMap.Builder<String, String> env) {
        env.put((Object)"de_l3s_icrawl_crawler_outputDirectory", (Object)this.outputDir);
        this.numUrls.ifPresent(num -> env.put((Object)"de_l3s_icrawl_crawler_numUrls", num));
    }

    @Override
    protected void addResources(ImmutableMap.Builder<String, LocalResource> resources) throws IOException {
        resources.put((Object)"specs", (Object)EvaluationClient.getResource(this.hdfsSpecPath, this.getConf(), LocalResourceType.ARCHIVE));
    }

    @Override
    protected String getAppMasterClass() {
        return EvaluationAppMaster.class.getName();
    }

    @Override
    protected String getJarPath() {
        return this.hdfsJarPath;
    }
}

