/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.codahale.metrics.ScheduledReporter;
import com.google.common.collect.ImmutableMap;
import de.l3s.icrawl.crawler.ArchiveCrawlSpecification;
import de.l3s.icrawl.crawler.Crawler;
import de.l3s.icrawl.crawler.analysis.ResourceAnalyser;
import de.l3s.icrawl.crawler.scheduling.CompositeStoppingCriterion;
import de.l3s.icrawl.crawler.scheduling.NumberOfUrlsStoppingCriterion;
import de.l3s.icrawl.crawler.scheduling.QueueEmptyCriterion;
import de.l3s.icrawl.crawler.yarn.BaseAppMaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.springframework.context.ApplicationContext;

public class EvaluationAppMaster
extends BaseAppMaster {
    @Override
    protected void addDefaultProps(ImmutableMap.Builder<String, Object> defaultProps) {
        defaultProps.put((Object)"maxUrls", (Object)this.getMaxUrls()).put((Object)"outputDirectory", (Object)System.getenv("de_l3s_icrawl_crawler_outputDirectory"));
    }

    @Override
    protected void crawl(ApplicationContext context, Crawler crawler) throws IOException {
        File[] specFiles;
        SuffixFileFilter filter = new SuffixFileFilter(".json");
        for (File specFile : specFiles = new File("specs").listFiles((FilenameFilter)filter)) {
            ArchiveCrawlSpecification spec = ArchiveCrawlSpecification.readFile(specFile);
            for (ResourceAnalyser.WeightingMethod method : ResourceAnalyser.WeightingMethod.values()) {
                for (int snapshotsToAnalyze : this.snapshotVariants(method)) {
                    CompositeStoppingCriterion stoppingCriterion = new CompositeStoppingCriterion(new NumberOfUrlsStoppingCriterion(this.getMaxUrls()), new QueueEmptyCriterion(30L, TimeUnit.SECONDS));
                    crawler.crawlContinuously(spec, stoppingCriterion, method, -1.7976931348623157E308, snapshotsToAnalyze);
                    ((ScheduledReporter)context.getBean(ScheduledReporter.class)).report();
                }
            }
            this.progress.addAndGet(1.0 / (double)specFiles.length);
        }
    }

    private List<Integer> snapshotVariants(ResourceAnalyser.WeightingMethod method) {
        switch (method) {
            case CONTENT: 
            case CONTENT_AND_TIME: 
            case CONTENT_AND_TIME_EXP: {
                return Arrays.asList(1, 10, 100);
            }
        }
        return Collections.singletonList(1);
    }

    @Override
    protected Set<String> getProfiles() {
        return Collections.singleton("evaluation");
    }

    public static void main(String[] args) throws Exception {
        new EvaluationAppMaster().run(args);
    }
}

