/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.l3s.icrawl.crawler.analysis.ResourceAnalyser;
import de.l3s.icrawl.crawler.yarn.AppMaster;
import de.l3s.icrawl.crawler.yarn.BaseClient;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;

public class Client
extends BaseClient {
    private Path hdfsSpecPath;
    private String hdfsJarPath;
    private String localSpecFile;
    private String outputDirectory;
    private Optional<String> numUrls;
    private Optional<String> weightingMethod;
    private Optional<String> relevanceThreshold;
    private Optional<String> snapshotsToAnalyze;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new Client(), (String[])args);
    }

    @Override
    protected void configure(String[] args) {
        if (!this.checkUsage(args)) {
            throw new IllegalArgumentException();
        }
        this.hdfsJarPath = args[0];
        this.localSpecFile = args[1];
        this.outputDirectory = args[2];
        this.numUrls = args.length > 3 ? Optional.of(args[3]) : Optional.empty();
        this.weightingMethod = args.length > 4 ? Optional.of(args[4]) : Optional.empty();
        this.weightingMethod.ifPresent(wm -> Preconditions.checkArgument((ResourceAnalyser.WeightingMethod.valueOf(wm) != null ? 1 : 0) != 0, (String)"Unknown weighting method %s", (Object[])new Object[]{wm}));
        this.relevanceThreshold = args.length > 5 ? Optional.of(args[5]) : Optional.empty();
        this.snapshotsToAnalyze = args.length > 6 ? Optional.of(args[6]) : Optional.empty();
    }

    @Override
    protected void cleanup() throws IOException {
        this.hdfsSpecPath.getFileSystem(this.getConf()).delete(this.hdfsSpecPath, false);
    }

    @Override
    protected void prepare() throws IOException {
        this.hdfsSpecPath = Client.uploadTempFile(new Path(this.localSpecFile), this.getConf(), "spec-", "json");
    }

    @Override
    protected boolean checkUsage(String[] args) {
        if (args.length >= 3) {
            return true;
        }
        System.err.println("Usage: java " + Client.class.getName() + " hdfsJarPath localSpecFile outputDirectory [numUrls [weightingMethod [relevanceThreshold [snapshotsToAnalyze]]");
        return false;
    }

    @Override
    protected void addParameters(ImmutableMap.Builder<String, String> env) {
        env.put((Object)"de_l3s_icrawl_crawler_outputDirectory", (Object)this.outputDirectory);
        this.numUrls.ifPresent(num -> env.put((Object)"de_l3s_icrawl_crawler_numUrls", num));
        this.weightingMethod.ifPresent(wm -> env.put((Object)"de_l3s_icrawl_crawler_weightingMethod", wm));
        this.relevanceThreshold.ifPresent(rt -> env.put((Object)"de_l3s_icrawl_crawler_relevanceThreshold", rt));
        this.snapshotsToAnalyze.ifPresent(count -> env.put((Object)"de_l3s_icrawl_crawler_snapshotsToAnalyze", count));
    }

    @Override
    protected void addResources(ImmutableMap.Builder<String, LocalResource> resources) throws IOException {
        resources.put((Object)"spec.json", (Object)Client.getResource(this.hdfsSpecPath, this.getConf(), LocalResourceType.FILE));
    }

    @Override
    protected String getAppMasterClass() {
        return AppMaster.class.getName();
    }

    @Override
    protected String getJarPath() {
        return this.hdfsJarPath;
    }
}

