/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
extends Configured
implements Tool {
    private static final int MEMORY_MB = 12288;
    private static final int NUM_CORES = 10;
    private static final String TEMP_FILES_PATH = "hdfs:///tmp/archive-crawler";
    private static final Logger LOG = LoggerFactory.getLogger(BaseClient.class);

    public int run(String[] args) throws YarnException, IOException, InterruptedException {
        this.configure(args);
        YarnClient client = YarnClient.createYarnClient();
        client.init(this.getConf());
        client.start();
        YarnClientApplication app = client.createApplication();
        this.prepare();
        ImmutableMap.Builder env = ImmutableMap.builder();
        env.put((Object)"CLASSPATH", (Object)this.getAMClassPath());
        this.addParameters((ImmutableMap.Builder<String, String>)env);
        ApplicationSubmissionContext appContext = this.createAM(this.getConf(), app.getApplicationSubmissionContext(), (Map<String, String>)env.build(), this.getJarPath());
        ApplicationId appId = client.submitApplication(appContext);
        this.waitAndPrint(client, appId);
        client.stop();
        this.cleanup();
        return 0;
    }

    protected void cleanup() throws IOException {
    }

    protected void prepare() throws IOException {
    }

    private void waitAndPrint(YarnClient client, ApplicationId appId) throws YarnException, IOException, InterruptedException {
        float previousProgress = -1.0f;
        boolean reportedUrl = false;
        while (true) {
            float progress;
            ApplicationReport report = client.getApplicationReport(appId);
            YarnApplicationState state = report.getYarnApplicationState();
            if (!reportedUrl && report.getTrackingUrl() != null) {
                LOG.info("Tracking URL: {}", (Object)report.getTrackingUrl());
                reportedUrl = true;
            }
            if ((double)Math.abs((progress = report.getProgress()) - previousProgress) >= 0.01) {
                LOG.info("State={}, Progress={}", (Object)state, (Object)Float.valueOf(progress));
            }
            if (state == YarnApplicationState.FINISHED || state == YarnApplicationState.KILLED) break;
            if (state == YarnApplicationState.FAILED) {
                LOG.info("Application {} failed with cause: ", (Object)appId, (Object)client.getFailureCause());
                break;
            }
            previousProgress = progress;
            TimeUnit.SECONDS.sleep(10L);
        }
        for (ApplicationAttemptReport report : client.getApplicationAttempts(appId)) {
            LOG.info("Attempt {} report: containerId={} diagnostics={}", new Object[]{report.getApplicationAttemptId(), report.getAMContainerId(), report.getDiagnostics()});
        }
    }

    protected abstract boolean checkUsage(String[] var1);

    protected void addParameters(ImmutableMap.Builder<String, String> env) {
    }

    private String getAMClassPath() {
        ArrayList classpathEntries = Lists.newArrayList((Object[])this.getConf().getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH));
        classpathEntries.add("$CDH_HBASE_HOME/lib/*");
        classpathEntries.add("./*");
        String classpath = Joiner.on((char)':').join((Iterable)classpathEntries);
        return classpath;
    }

    private ApplicationSubmissionContext createAM(Configuration conf, ApplicationSubmissionContext appContext, Map<String, String> env, String jarPath) throws IOException {
        appContext.setApplicationName("archive-crawler");
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(12288);
        resource.setVirtualCores(10);
        appContext.setResource(resource);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        ImmutableMap.Builder resources = ImmutableMap.builder();
        resources.put((Object)"AppMaster.jar", (Object)BaseClient.getResource(new Path(jarPath), conf, LocalResourceType.FILE));
        this.addResources((ImmutableMap.Builder<String, LocalResource>)resources);
        amContainer.setLocalResources((Map)resources.build());
        amContainer.setEnvironment(env);
        amContainer.setCommands(this.getAMCommands());
        appContext.setAMContainerSpec(amContainer);
        return appContext;
    }

    protected void addResources(ImmutableMap.Builder<String, LocalResource> resources) throws IOException {
    }

    private List<String> getAMCommands() {
        String libJarValue = this.getConf().get("tmpjars", "");
        StringBuilder libjars = new StringBuilder();
        for (String jar : libJarValue.split(",")) {
            try {
                libjars.append(new File(new URI(jar)).getAbsolutePath()).append(':');
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                LOG.info("Illegal jar path: {}", (Object)jar);
            }
        }
        return Collections.singletonList(String.format("${JAVA_HOME}/bin/java -Xmx10G -cp ./*:%s$CLASSPATH %s --logdir=%s 1>%s/stdout 2>%s/stderr", libjars, this.getAppMasterClass(), "<LOG_DIR>", "<LOG_DIR>", "<LOG_DIR>"));
    }

    protected abstract String getAppMasterClass();

    protected static Path uploadTempFile(Path localPath, Configuration conf, String prefix, String extension) throws IOException {
        Path tmpDir = new Path(TEMP_FILES_PATH);
        FileSystem fs = tmpDir.getFileSystem(conf);
        fs.mkdirs(tmpDir);
        int rand = new Random().nextInt(Integer.MAX_VALUE);
        Path hdfsPath = new Path(tmpDir, String.format(Locale.ROOT, "%s%05d.%s", prefix, rand, extension));
        LOG.info("Uploading local file {} to HDFS path {}", (Object)localPath, (Object)hdfsPath);
        fs.copyFromLocalFile(localPath, hdfsPath);
        return hdfsPath;
    }

    protected static LocalResource getResource(Path path, Configuration conf, LocalResourceType resourceType) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        FileStatus jarStatus = fs.getFileStatus(path);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(resourceType);
        amJarRsrc.setVisibility(LocalResourceVisibility.APPLICATION);
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)path));
        amJarRsrc.setTimestamp(jarStatus.getModificationTime());
        amJarRsrc.setSize(jarStatus.getLen());
        return amJarRsrc;
    }

    protected abstract String getJarPath();

    protected void configure(String[] args) {
    }
}

