/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AtomicDouble;
import de.l3s.icrawl.crawler.ArchiveCrawler;
import de.l3s.icrawl.crawler.Crawler;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class BaseAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAppMaster.class);
    protected final Configuration conf = HBaseConfiguration.create((Configuration)new YarnConfiguration());
    protected final AtomicDouble progress = new AtomicDouble();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws YarnException, IOException {
        LOG.info("Starting AppMaster with args {}", (Object)args);
        AMRMClient rmClient = AMRMClient.createAMRMClient();
        rmClient.init(this.conf);
        rmClient.start();
        NMClient nmClient = NMClient.createNMClient();
        nmClient.init(this.conf);
        nmClient.start();
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> heartBeatfuture = this.startHeartBeatTask(this.conf, (AMRMClient<AMRMClient.ContainerRequest>)rmClient, executorService, this.progress);
        try {
            String basePath;
            SpringApplication app = new SpringApplication(new Object[]{ArchiveCrawler.class});
            Set<String> profiles = this.getProfiles();
            if (!profiles.isEmpty()) {
                app.setAdditionalProfiles(profiles.toArray(new String[0]));
            }
            if (!(basePath = "/yarn2" + System.getenv("APPLICATION_WEB_PROXY_BASE")).endsWith("/")) {
                basePath = basePath + "/";
            }
            ImmutableMap.Builder defaultProps = ImmutableMap.builder();
            defaultProps.put((Object)"basePath", (Object)basePath);
            this.addDefaultProps((ImmutableMap.Builder<String, Object>)defaultProps);
            app.setDefaultProperties((Map)defaultProps.build());
            ConfigurableApplicationContext context = app.run(args);
            int serverPort = ((ArchiveCrawler)context.getBean(ArchiveCrawler.class)).getServerPort();
            String hostname = BaseAppMaster.getHostname();
            rmClient.registerApplicationMaster(hostname, 0, "http://" + hostname + ":" + serverPort + "/");
            LOG.info("registerApplicationMaster done");
            Crawler crawler = (Crawler)context.getBean(Crawler.class);
            this.crawl((ApplicationContext)context, crawler);
            crawler.shutdown();
            rmClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, "Finished", null);
        }
        catch (Exception e) {
            LOG.info("Failed with exception: ", (Throwable)e);
            rmClient.unregisterApplicationMaster(FinalApplicationStatus.FAILED, e.getMessage(), null);
        }
        finally {
            if (heartBeatfuture != null) {
                heartBeatfuture.cancel(true);
            }
            executorService.shutdown();
            LOG.info("Shutdown of heartbeat is finished.");
        }
    }

    protected Set<String> getProfiles() {
        return Collections.emptySet();
    }

    protected abstract void crawl(ApplicationContext var1, Crawler var2) throws IOException;

    protected void addDefaultProps(ImmutableMap.Builder<String, Object> defaultProps) {
    }

    protected long getMaxUrls() {
        String maxUrlsEnv = System.getenv("de_l3s_icrawl_crawler_numUrls");
        return maxUrlsEnv != null ? Long.parseLong(maxUrlsEnv) : 10000L;
    }

    private ScheduledFuture<?> startHeartBeatTask(Configuration conf, AMRMClient<AMRMClient.ContainerRequest> rmClient, ScheduledExecutorService executorService, AtomicDouble progress) {
        int heartBeatInterval = conf.getInt("yarn.am.liveness-monitor.expiry-interval-ms", 600000) / 2;
        heartBeatInterval = Math.min(heartBeatInterval, 10000);
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(() -> {
            try {
                rmClient.allocate(progress.floatValue());
            }
            catch (Exception e) {
                LOG.info("Exception during heartbeat", (Throwable)e);
            }
        }, heartBeatInterval, heartBeatInterval, TimeUnit.MILLISECONDS);
        LOG.info("Started heartbeat task {} every {} ms", future, (Object)heartBeatInterval);
        return future;
    }

    private static String getHostname() {
        try {
            return BaseAppMaster.enumerationAsStream(NetworkInterface.getNetworkInterfaces()).filter(BaseAppMaster::notLoopback).flatMap(ni -> BaseAppMaster.enumerationAsStream(ni.getInetAddresses())).filter(addr -> addr instanceof Inet4Address).map(InetAddress::getCanonicalHostName).findFirst().orElse("localhost");
        }
        catch (SocketException e) {
            LOG.info("Exception while retrieving hostName", (Throwable)e);
            return "localhost";
        }
    }

    private static boolean notLoopback(NetworkInterface ni) {
        try {
            return !ni.isLoopback();
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static <T> Stream<T> enumerationAsStream(final Enumeration<T> e) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, 16), false);
    }
}

