/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.yarn;

import com.codahale.metrics.ScheduledReporter;
import com.google.common.collect.ImmutableMap;
import de.l3s.icrawl.crawler.ArchiveCrawlSpecification;
import de.l3s.icrawl.crawler.Crawler;
import de.l3s.icrawl.crawler.analysis.ResourceAnalyser;
import de.l3s.icrawl.crawler.scheduling.CompositeStoppingCriterion;
import de.l3s.icrawl.crawler.scheduling.NumberOfUrlsStoppingCriterion;
import de.l3s.icrawl.crawler.scheduling.QueueEmptyCriterion;
import de.l3s.icrawl.crawler.yarn.BaseAppMaster;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;

public class AppMaster
extends BaseAppMaster {
    @Override
    protected void addDefaultProps(ImmutableMap.Builder<String, Object> defaultProps) {
        defaultProps.put((Object)"maxUrls", (Object)this.getMaxUrls()).put((Object)"outputDirectory", (Object)System.getenv("de_l3s_icrawl_crawler_outputDirectory"));
    }

    @Override
    protected void crawl(ApplicationContext context, Crawler crawler) throws IOException {
        File specFile = new File("spec.json");
        ArchiveCrawlSpecification spec = ArchiveCrawlSpecification.readFile(specFile);
        ResourceAnalyser.WeightingMethod method = Optional.ofNullable(System.getenv("de_l3s_icrawl_crawler_weightingMethod")).map(ResourceAnalyser.WeightingMethod::valueOf).orElse(ResourceAnalyser.WeightingMethod.CONTENT_AND_TIME);
        double relevanceThreshold = Optional.ofNullable(System.getenv("de_l3s_icrawl_crawler_relevanceThreshold")).map(Double::valueOf).orElse(-1.7976931348623157E308);
        int snapshotsToAnalyze = Optional.ofNullable(System.getenv("de_l3s_icrawl_crawler_snapshotsToAnalyze")).map(Integer::valueOf).orElse(1);
        NumberOfUrlsStoppingCriterion urlsStoppingCriterion = new NumberOfUrlsStoppingCriterion(this.getMaxUrls());
        CompositeStoppingCriterion stoppingCriterion = new CompositeStoppingCriterion(urlsStoppingCriterion, new QueueEmptyCriterion(30L, TimeUnit.SECONDS));
        ScheduledFuture<?> future = Executors.newSingleThreadScheduledExecutor().schedule(() -> this.progress.set((double)urlsStoppingCriterion.getProgress()), 1L, TimeUnit.SECONDS);
        crawler.crawlContinuously(spec, stoppingCriterion, method, relevanceThreshold, snapshotsToAnalyze);
        ((ScheduledReporter)context.getBean(ScheduledReporter.class)).report();
        future.cancel(false);
        this.progress.set(1.0);
    }

    @Override
    protected Set<String> getProfiles() {
        return Collections.singleton("extract");
    }

    public static void main(String[] args) throws Exception {
        new AppMaster().run(args);
    }
}

