/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.urls;

import de.l3s.icrawl.crawler.urls.UrlNormalizer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class RegexUrlNormalizer
implements UrlNormalizer {
    private final List<RegexReplaceRule> rules;

    public RegexUrlNormalizer(URL normalizerRulesResource) throws IOException {
        try (InputStream is = normalizerRulesResource.openStream();){
            Document rulesDoc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            this.rules = new ArrayList<RegexReplaceRule>();
            for (Element e : rulesDoc.select("regex")) {
                String pattern = e.select("pattern").first().text();
                String replacement = e.select("substitution").first().text();
                this.rules.add(new RegexReplaceRule(pattern, replacement));
            }
        }
    }

    @Override
    public String normalize(String url) {
        String result = url;
        for (RegexReplaceRule rule : this.rules) {
            result = rule.apply(result);
        }
        return result;
    }

    private static class RegexReplaceRule {
        private final Pattern pattern;
        private final String replacement;

        public RegexReplaceRule(String pattern, String replacement) {
            this.pattern = Pattern.compile(pattern);
            this.replacement = replacement;
        }

        public String apply(String input) {
            return this.pattern.matcher(input).replaceAll(this.replacement);
        }
    }
}

