/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.ui;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import de.l3s.icrawl.crawler.ArchiveCrawlSpecification;
import de.l3s.icrawl.crawler.Crawler;
import de.l3s.icrawl.crawler.ui.UiConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InfoController {
    @Inject
    MetricRegistry metrics;
    @Inject
    Crawler crawler;
    @Inject
    EmbeddedWebApplicationContext context;
    @Inject
    @Value(value="${basePath}")
    String basePath;
    @Inject
    @Value(value="${logdir}")
    File logsDir;
    private static final Pattern CLASS_BASED_METRIC = Pattern.compile("([a-z.]+\\.[A-Z][a-zA-Z]+)\\.(.*)");

    @RequestMapping(value={"/"})
    public ModelAndView status() {
        Optional<ArchiveCrawlSpecification> spec = this.crawler.getCurrentSpec();
        String crawlName = spec.isPresent() ? spec.get().getName() : "no crawl";
        return new ModelAndView("status").addObject("basePath", (Object)this.basePath).addObject("counters", InfoController.metricHierarchy(this.metrics.getCounters())).addObject("gauges", InfoController.metricHierarchy(this.metrics.getGauges())).addObject("histograms", InfoController.metricHierarchy(this.metrics.getHistograms())).addObject("meters", InfoController.metricHierarchy(this.metrics.getMeters())).addObject("timers", InfoController.metricHierarchy(this.metrics.getTimers())).addObject("crawlName", (Object)crawlName);
    }

    static <T extends Metric> SortedMap<String, SortedMap<String, T>> metricHierarchy(SortedMap<String, T> metrics) {
        TreeMap<String, SortedMap<String, T>> result = new TreeMap<String, SortedMap<String, T>>();
        for (Map.Entry<String, T> entry : metrics.entrySet()) {
            String key;
            String group;
            String originalKey = entry.getKey();
            Matcher m = CLASS_BASED_METRIC.matcher(originalKey);
            if (m.matches()) {
                group = m.group(1);
                key = m.group(2);
            } else {
                int seperatorPos = originalKey.lastIndexOf(".");
                if (seperatorPos >= 0) {
                    group = originalKey.substring(0, seperatorPos);
                    key = originalKey.substring(seperatorPos + 1);
                } else {
                    group = "";
                    key = originalKey;
                }
            }
            SortedMap groupMap = result.getOrDefault(group, new TreeMap());
            groupMap.put(key, entry.getValue());
            result.put(group, groupMap);
        }
        return result;
    }

    @RequestMapping(value={"env"})
    public ModelAndView environment() {
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threads.dumpAllThreads(true, true);
        return new ModelAndView("env").addObject("basePath", (Object)this.basePath).addObject("headers", System.getenv()).addObject("threads", (Object)threadInfos);
    }

    @RequestMapping(value={"logs/"})
    public ModelAndView list() {
        Object[] files = this.logsDir.listFiles((FileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, HiddenFileFilter.VISIBLE}));
        Arrays.sort(files);
        return new ModelAndView("logs").addObject("basePath", (Object)this.basePath).addObject("files", (Object)files).addObject("logsDir", (Object)this.logsDir);
    }

    @RequestMapping(value={"logs/{path}"})
    @ResponseBody
    public HttpEntity<?> show(@PathVariable String path) throws IOException {
        File file = new File(this.logsDir, path);
        if (!file.exists()) {
            throw new UiConfig.ResourceNotFoundException(path);
        }
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)new FileSystemResource(file));
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.GET, RequestMethod.POST})
    public View stop() {
        this.crawler.shutdown();
        this.context.getEmbeddedServletContainer().stop();
        this.context.stop();
        return new RedirectView(this.basePath);
    }
}

