/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.tools;

import com.google.common.io.Files;
import de.l3s.icrawl.crawler.ArchiveCrawlSpecification;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class MergeExternalUrls {
    public static void main(String[] args) throws IOException {
        for (String path : args) {
            for (File specFile : new File(path).listFiles((dir, name) -> name.endsWith(".json"))) {
                ArchiveCrawlSpecification spec = ArchiveCrawlSpecification.readFile(specFile);
                String urlsFileName = specFile.getName().replaceFirst("\\.json$", ".txt");
                File urlsFile = new File(specFile.getParentFile(), urlsFileName);
                if (!urlsFile.exists()) continue;
                List newSeedUrls = Files.readLines((File)urlsFile, (Charset)StandardCharsets.UTF_8);
                ArchiveCrawlSpecification newSpec = spec.withSeedUrls(newSeedUrls);
                String newSpecFileName = specFile.getName().replaceFirst("\\.json", "-seeds.json");
                newSpec.writeFile(new File(specFile.getParentFile(), newSpecFileName));
                System.out.printf("Updated %s with %d new URLs%n", specFile, newSeedUrls.size());
            }
        }
    }
}

