/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.scheduling;

import com.codahale.metrics.Gauge;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoppingCriterion
implements Gauge<Float> {
    private static final Logger logger = LoggerFactory.getLogger(StoppingCriterion.class);
    private final List<StopListener> listeners = new CopyOnWriteArrayList<StopListener>();
    private final AtomicBoolean didNotify = new AtomicBoolean(false);

    public void updateSuccess(double relevance) {
    }

    public void updateFailure() {
    }

    public void updateEmptyQueue() {
    }

    public void updateIrrelevant(double relevance) {
    }

    public void addListener(StopListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(StopListener listener) {
        return this.listeners.remove(listener);
    }

    protected void stop() {
        if (!this.didNotify.compareAndSet(false, true)) {
            logger.debug("Already did notification, skipping");
            return;
        }
        for (StopListener listener : this.listeners) {
            listener.stop();
        }
        this.listeners.clear();
    }

    public Float getValue() {
        return Float.valueOf(this.getProgress());
    }

    public abstract float getProgress();

    public static interface StopListener {
        public void stop();
    }
}

