/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.scheduling;

import de.l3s.icrawl.crawler.scheduling.StoppingCriterion;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class QueueEmptyCriterion
extends StoppingCriterion {
    private final long timeOut;
    private final TimeUnit timeOutUnit;
    private final ScheduledExecutorService queueStopperRunner = Executors.newSingleThreadScheduledExecutor();
    private Future<?> queueStopper;
    private LocalDateTime started;

    public QueueEmptyCriterion(long timeOut, TimeUnit timeOutUnit) {
        this.timeOut = timeOut;
        this.timeOutUnit = timeOutUnit;
    }

    @Override
    public void updateSuccess(double relevance) {
        this.cancelTimeout();
    }

    @Override
    public void updateFailure() {
        this.cancelTimeout();
    }

    @Override
    public void updateIrrelevant(double relevance) {
        this.cancelTimeout();
    }

    private void cancelTimeout() {
        if (this.queueStopper != null) {
            this.queueStopper.cancel(true);
            this.queueStopper = null;
        }
    }

    @Override
    public void updateEmptyQueue() {
        if (this.queueStopper == null) {
            this.queueStopper = this.queueStopperRunner.schedule(new Runnable(){

                @Override
                public void run() {
                    QueueEmptyCriterion.this.stop();
                }
            }, this.timeOut, this.timeOutUnit);
            this.started = LocalDateTime.now();
        }
    }

    @Override
    public float getProgress() {
        if (this.queueStopper != null) {
            LocalDateTime now = LocalDateTime.now();
            long elapsedMillis = Duration.between(this.started, now).toMillis();
            long totalMillis = Duration.of(this.timeOut, QueueEmptyCriterion.temporalUnit(this.timeOutUnit)).toMillis();
            return (float)((double)elapsedMillis / (double)totalMillis);
        }
        return 0.0f;
    }

    private static TemporalUnit temporalUnit(TimeUnit timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
        }
        throw new IllegalArgumentException("Unknown timeUnit " + (Object)((Object)timeUnit));
    }
}

