/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.scheduling;

import de.l3s.icrawl.crawler.scheduling.StoppingCriterion;
import java.util.concurrent.atomic.AtomicLong;

public class NumberOfUrlsStoppingCriterion
extends StoppingCriterion {
    private final AtomicLong counter = new AtomicLong();
    private final long maxUrls;

    public NumberOfUrlsStoppingCriterion(long maxUrls) {
        this.maxUrls = maxUrls;
    }

    @Override
    public void updateSuccess(double relevance) {
        long newValue = this.counter.incrementAndGet();
        if (newValue >= this.maxUrls) {
            this.stop();
        }
    }

    @Override
    public float getProgress() {
        return this.counter.floatValue() / (float)this.maxUrls;
    }
}

