/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.io;

import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.CrawledResource;
import de.l3s.icrawl.crawler.io.ResultStorer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileStorer
implements ResultStorer {
    private static final Logger LOG = LoggerFactory.getLogger(ZipFileStorer.class);
    private final ZipOutputStream os;
    private final Object successLock = new Object();
    private final Object failLock = new Object();
    private final Object writeLock = new Object();
    private final List<StoredUrl> successfullUrls;
    private final List<CrawlUrl> failedUrls;

    public ZipFileStorer(OutputStream os, int numResults) {
        this.os = new ZipOutputStream(os, StandardCharsets.UTF_8);
        this.successfullUrls = new ArrayList<StoredUrl>(numResults);
        this.failedUrls = new ArrayList<CrawlUrl>(numResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(CrawledResource resource) {
        Object object = this.successLock;
        synchronized (object) {
            try {
                int index = this.successfullUrls.size();
                String fileName = index + ".html";
                this.successfullUrls.add(new StoredUrl(resource, fileName));
                Object content = resource.getResource().getContent();
                byte[] bytes = content instanceof String ? ((String)content).getBytes(StandardCharsets.UTF_8) : (byte[])content;
                Instant crawlTime = resource.getResource().getCrawlTime().toInstant();
                this.writeZipEntry(fileName, crawlTime, bytes);
            }
            catch (IOException e) {
                LOG.info("Exception while storing result '{}':", (Object)resource, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(String fileName, Instant timestamp, byte[] bytes) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ZipEntry entry = new ZipEntry(fileName);
            entry.setCreationTime(FileTime.from(timestamp));
            this.os.putNextEntry(entry);
            this.os.write(bytes);
            this.os.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNotFound(CrawlUrl url) {
        Object object = this.failLock;
        synchronized (object) {
            this.failedUrls.add(url);
        }
    }

    @Override
    public void close() throws IOException {
        this.writeTOC();
        this.writeMissing();
        this.os.close();
    }

    private void writeMissing() throws IOException {
        if (this.failedUrls.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(this.failedUrls.size() * 200);
        sb.append("url\tpath\tpriority\n");
        for (CrawlUrl failedUrl : this.failedUrls) {
            sb.append(failedUrl.getUrl()).append('\t').append(failedUrl.getPath()).append('\t').append(failedUrl.getPriority()).append('\n');
        }
        this.writeZipEntry("missing.csv", Instant.now(), sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private void writeTOC() throws IOException {
        if (this.successfullUrls.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(this.successfullUrls.size() * 200);
        sb.append("url\tpath\trelevance\tcrawlTime\tfile\tmodifiedDate\n");
        for (StoredUrl storedUrl : this.successfullUrls) {
            sb.append(storedUrl.url).append('\t').append(storedUrl.path).append('\t').append(storedUrl.relevance).append('\t').append(storedUrl.crawlTime.toString()).append('\t').append(storedUrl.fileName).append('\t').append(storedUrl.modifiedDate).append('\n');
        }
        this.writeZipEntry("urls.csv", Instant.now(), sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static class StoredUrl {
        private final String url;
        private final String path;
        private final double relevance;
        private final ZonedDateTime crawlTime;
        private final String fileName;
        private final ZonedDateTime modifiedDate;

        public StoredUrl(CrawledResource resource, String fileName) {
            this.url = resource.getUrl();
            this.path = resource.getPath();
            this.relevance = resource.getRelevance();
            this.crawlTime = resource.getResource().getCrawlTime();
            this.fileName = fileName;
            this.modifiedDate = resource.getModifiedDate();
        }
    }
}

