/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.io;

import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.CrawledResource;
import de.l3s.icrawl.crawler.io.ResultStorer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvStorer
implements ResultStorer,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CsvStorer.class);
    private final TransferQueue<String> queue = new LinkedTransferQueue<String>();
    private final WriterThread writer;

    public CsvStorer(Configuration conf, Path outputFile) throws IOException {
        this.writer = new WriterThread(conf, outputFile, this.queue);
        Executors.newSingleThreadExecutor().submit(this.writer);
        this.sendMessage("url\tcrawlTime\tpath\tstatus\tcrawlPriority\trelevance\tmodifiedDate\tsnapshotsDuration\tminRelevance\tmaxRelevance%n", new Object[0]);
    }

    @Override
    public void store(CrawledResource resource) {
        this.sendMessage("%s\t%s\t%s\t%d\t%f\t%f\t%s\t%s\t%f\t%f%n", resource.getUrl(), resource.getResource().getCrawlTime(), resource.getPath(), resource.getResource().getStatus(), Float.valueOf(resource.getCrawlPriority()), resource.getRelevance(), resource.getModifiedDate(), resource.getSnapshotsDuration(), resource.getMinRelevance(), resource.getMaxRelevance());
    }

    @Override
    public void storeNotFound(CrawlUrl url) {
        this.sendMessage("%s\t-\t%s\t404\t%f\t-%n", url.getUrl(), url.getPath(), Float.valueOf(url.getPriority()));
    }

    private void sendMessage(String format, Object ... args) {
        String message = String.format(Locale.ROOT, format, args);
        try {
            boolean sent = this.queue.tryTransfer(message, 30L, TimeUnit.SECONDS);
            if (!sent) {
                logger.debug("Could not send message '{}' (timeout), dropping it", (Object)message);
            }
        }
        catch (InterruptedException e) {
            logger.info("Interrupted while sending message '{}', dropping it", (Object)message, (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.stop();
    }

    private static class WriterThread
    implements Runnable,
    Closeable {
        private boolean stopped = false;
        private final Writer writer;
        private final TransferQueue<String> queue;
        private final Path outputFile;

        public WriterThread(Configuration conf, Path outputFile, TransferQueue<String> queue) throws IOException {
            this.outputFile = outputFile;
            this.queue = queue;
            this.writer = new OutputStreamWriter((OutputStream)FileSystem.get((Configuration)conf).create(outputFile, true, 8048), StandardCharsets.UTF_8);
        }

        @Override
        public void run() {
            try {
                while (!this.stopped) {
                    String message = (String)this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (message == null) continue;
                    this.writer.write(message);
                }
            }
            catch (InterruptedException e) {
                logger.info("Exception while reading from queue, aborting", (Throwable)e);
            }
            catch (IOException e) {
                logger.info("Could not write to file {}, aborting", (Object)this.outputFile, (Object)e);
            }
            finally {
                this.close();
            }
        }

        @Override
        public void close() {
            logger.info("Closing storer for {}", (Object)this.outputFile);
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.info("Exception while closing writer:", (Throwable)e);
            }
        }

        public void stop() {
            int waiting = this.queue.getWaitingConsumerCount();
            ArrayList buffer = new ArrayList(waiting);
            while (this.queue.drainTo(buffer) > 0) {
                try {
                    for (String message : buffer) {
                        this.writer.write(message);
                    }
                }
                catch (IOException e) {
                    logger.info("Exception while draining remaining messages", (Throwable)e);
                }
            }
            this.stopped = true;
        }
    }
}

