/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.io;

import com.codahale.metrics.MetricRegistry;
import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.TimeSpecification;
import de.l3s.icrawl.snapshots.ArchiveRecordParser;
import de.l3s.icrawl.snapshots.DirectoryPrefixResolver;
import de.l3s.icrawl.snapshots.HBaseSnapshotsLocator;
import de.l3s.icrawl.snapshots.HdfsSnapshotReader;
import de.l3s.icrawl.snapshots.LocationResolver;
import de.l3s.icrawl.snapshots.SnaphotLocation;
import de.l3s.icrawl.snapshots.Snapshot;
import de.l3s.icrawl.snapshots.SnapshotsLocator;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFetcher
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveFetcher.class);
    private final SnapshotsLocator locator;
    private final LocationResolver locationResolver;
    private final HdfsSnapshotReader reader;
    private final ArchiveRecordParser recordParser = new ArchiveRecordParser();
    private final int versionsToCheck;

    public ArchiveFetcher(Configuration conf, String indexPath, String dataPath, MetricRegistry metrics, int versionsToCheck) throws IOException {
        this.versionsToCheck = versionsToCheck;
        this.locator = new HBaseSnapshotsLocator(conf, metrics);
        this.locationResolver = new DirectoryPrefixResolver(dataPath);
        this.reader = new HdfsSnapshotReader(conf, metrics);
    }

    public List<Snapshot> get(CrawlUrl url, TimeSpecification referenceTime) throws IOException {
        Iterable<SnaphotLocation> locations = this.locator.findLocations(url.getUrl());
        locations = referenceTime.findBest(locations, this.versionsToCheck);
        return StreamSupport.stream(locations.spliterator(), false).map(location -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        if (this.locator instanceof Closeable) {
            ((Closeable)((Object)this.locator)).close();
        }
    }
}

