/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.frontier;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.ThreadLocalRandom;

public class WeightedRandomSelector {
    private final double[] distribution;
    private final BitSet enabled;
    private double[] activeValues;

    public WeightedRandomSelector(int choices, int base) {
        this.distribution = WeightedRandomSelector.createWeightedDistribution(choices, base);
        this.enabled = new BitSet(choices);
    }

    private static double[] createWeightedDistribution(int choices, int base) {
        double normalization = base == 1 ? (double)(base + 1) : (Math.pow(base, choices + 1) - 1.0) / (double)(base - 1);
        double[] ret = new double[choices];
        for (int i = 0; i < choices; ++i) {
            ret[i] = Math.pow(base, choices - i) / normalization;
        }
        return ret;
    }

    public int next() {
        if (this.activeValues == null) {
            this.activeValues = this.fillActiveValues();
        }
        if (this.activeValues.length == 0) {
            return -1;
        }
        double random = ThreadLocalRandom.current().nextDouble(this.activeValues[this.activeValues.length - 1]);
        int selected = WeightedRandomSelector.findPosition(this.activeValues, random);
        return this.distribution.length - this.originalIndex(selected) - 1;
    }

    @VisibleForTesting
    static int findPosition(double[] haystack, double needle) {
        int pos = Arrays.binarySearch(haystack, needle);
        return pos >= 0 ? pos : -(pos + 1);
    }

    private int originalIndex(int idx) {
        int i = this.enabled.nextSetBit(0);
        int pos = 0;
        while (i >= 0) {
            if (pos++ == idx) {
                return i;
            }
            i = this.enabled.nextSetBit(i + 1);
        }
        return -1;
    }

    private double[] fillActiveValues() {
        int active = this.enabled.cardinality();
        double[] values = new double[active];
        int valIdx = 0;
        int i = this.enabled.nextSetBit(0);
        while (i >= 0) {
            values[valIdx] = this.distribution[i];
            if (valIdx >= 1) {
                int n = valIdx;
                values[n] = values[n] + values[valIdx - 1];
            }
            ++valIdx;
            i = this.enabled.nextSetBit(i + 1);
        }
        return values;
    }

    public void enable(int idx) {
        this.set(idx, true);
    }

    public void disable(int idx) {
        this.set(idx, false);
    }

    private void set(int idx, boolean value) {
        int flippedIndex = this.distribution.length - idx - 1;
        if (this.enabled.get(flippedIndex) != value) {
            this.enabled.flip(flippedIndex);
            this.activeValues = null;
        }
    }
}

