/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.frontier;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.frontier.BaseFrontier;
import de.l3s.icrawl.crawler.frontier.Frontier;
import java.util.LinkedList;
import java.util.Optional;

public class InMemoryFrontier
extends BaseFrontier
implements Frontier {
    private final LinkedList<CrawlUrl> queue = new LinkedList();

    public InMemoryFrontier(MetricRegistry metrics) {
        super(metrics);
        metrics.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"size"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InMemoryFrontier.this.queue.size();
            }
        });
    }

    @Override
    protected void pushInternal(CrawlUrl url) {
        this.queue.offer(url);
    }

    @Override
    protected Optional<CrawlUrl> popInternal() {
        return Optional.ofNullable(this.queue.poll());
    }
}

