/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.frontier;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.frontier.BaseFrontier;
import de.l3s.icrawl.crawler.frontier.Frontier;
import de.l3s.icrawl.crawler.frontier.WeightedRandomSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedFrontier
extends BaseFrontier
implements Frontier {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedFrontier.class);
    final RandomAccessFile[] files;
    private long[] readIndices;
    private long[] writeIndices;
    private final File queueDirectory;
    private final double intervalSize;
    private final WeightedRandomSelector selector;
    private final boolean persist;

    public FileBasedFrontier(File queueDirectory, MetricRegistry metrics, int numQueues, boolean persist) throws IOException {
        super(metrics);
        this.intervalSize = 1.0 / (double)numQueues;
        this.queueDirectory = queueDirectory;
        this.files = new RandomAccessFile[numQueues];
        int width = Math.max((int)Math.log10(numQueues), 1);
        queueDirectory.mkdirs();
        for (int i = 0; i < numQueues; ++i) {
            this.files[i] = new RandomAccessFile(this.queueFile(queueDirectory, width, i + 1), "rw");
        }
        File positionsFile = this.positionsFile(queueDirectory);
        if (persist && positionsFile.exists()) {
            logger.info("Continuing queue from positions in {}", (Object)positionsFile.getAbsoluteFile());
            try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(positionsFile));){
                for (int i = 0; i < numQueues; ++i) {
                    this.readIndices[i] = is.readLong();
                    this.writeIndices[i] = is.readLong();
                }
            }
        } else {
            this.readIndices = new long[numQueues];
            this.writeIndices = new long[numQueues];
        }
        this.selector = new WeightedRandomSelector(numQueues, 2);
        this.persist = persist;
    }

    private File queueFile(File queueDirectory, int width, int priority) {
        return new File(queueDirectory, String.format(Locale.ROOT, "%" + width + "f", (double)priority * this.intervalSize));
    }

    private File positionsFile(File queueDirectory) {
        return new File(queueDirectory, "positions");
    }

    @Override
    protected void pushInternal(CrawlUrl url) {
        try {
            int queueIndex = (int)((double)url.getPriority() / this.intervalSize);
            if (queueIndex == this.files.length) {
                queueIndex = this.files.length - 1;
            }
            RandomAccessFile file = this.files[queueIndex];
            file.seek(this.writeIndices[queueIndex]);
            file.writeUTF(url.getUrl());
            file.writeUTF(url.getPath());
            file.writeFloat(url.getPriority());
            if (url.getReferrer() != null) {
                file.writeBoolean(true);
                file.writeUTF(url.getReferrer());
                file.writeUTF(url.getRefererCrawlTime().toString());
            } else {
                file.writeBoolean(false);
            }
            this.writeIndices[queueIndex] = file.getFilePointer();
            this.selector.enable(queueIndex);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected Optional<CrawlUrl> popInternal() {
        if (this.allQueuesEmpty()) {
            return Optional.empty();
        }
        try {
            ZonedDateTime referrerCrawlTime;
            String referrer;
            int queueIndex = this.selector.next();
            if (queueIndex < 0) {
                return Optional.empty();
            }
            RandomAccessFile file = this.files[queueIndex];
            file.seek(this.readIndices[queueIndex]);
            String url = file.readUTF();
            String path = file.readUTF();
            float priority = file.readFloat();
            if (file.readBoolean()) {
                referrer = file.readUTF();
                referrerCrawlTime = ZonedDateTime.parse(file.readUTF());
            } else {
                referrer = null;
                referrerCrawlTime = null;
            }
            this.readIndices[queueIndex] = file.getFilePointer();
            if (this.isQueueEmpty(queueIndex)) {
                this.selector.disable(queueIndex);
            }
            return Optional.of(new CrawlUrl(url, path, priority, referrer, referrerCrawlTime));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean allQueuesEmpty() {
        for (int i = 0; i < this.files.length; ++i) {
            if (this.isQueueEmpty(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isQueueEmpty(int queueIndex) {
        return this.readIndices[queueIndex] >= this.writeIndices[queueIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void close() throws IOException {
        super.close();
        Object object = this.lock;
        synchronized (object) {
            for (RandomAccessFile randomAccessFile : this.files) {
                randomAccessFile.close();
            }
            if (this.persist) {
                File positionsFile = this.positionsFile(this.queueDirectory);
                try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(positionsFile));){
                    void var5_9;
                    boolean bl = false;
                    while (var5_9 < this.files.length) {
                        os.writeLong(this.readIndices[var5_9]);
                        os.writeLong(this.writeIndices[var5_9]);
                        ++var5_9;
                    }
                }
                logger.info("Wrote current positions to {}", (Object)positionsFile.getAbsoluteFile());
            } else {
                for (File file : this.queueDirectory.listFiles()) {
                    file.delete();
                }
                this.queueDirectory.delete();
                logger.info("Removed queue in {}", (Object)this.queueDirectory.getAbsoluteFile());
            }
        }
    }
}

