/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler.frontier;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.frontier.ClassMetricFilter;
import de.l3s.icrawl.crawler.frontier.Frontier;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;

public abstract class BaseFrontier
implements Frontier,
Closeable {
    protected final BloomFilter<CharSequence> seenUrls = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.US_ASCII), (int)1000000);
    private final MetricRegistry metrics;
    protected final Meter incoming;
    protected final Meter outgoing;
    private Counter size;
    protected Meter emptyQueue;
    protected long totalIncoming = 0L;
    protected final Object lock = new Object();

    public BaseFrontier(MetricRegistry metrics) {
        this.metrics = metrics;
        this.incoming = metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"incomingUrls"}));
        this.outgoing = metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"outgoingUrls"}));
        this.emptyQueue = metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"emptyQueue"}));
        this.size = metrics.counter(MetricRegistry.name(this.getClass(), (String[])new String[]{"size"}));
        metrics.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"seenUrlsFpp"}), (Metric)new Gauge<Double>(){

            public Double getValue() {
                return BaseFrontier.this.seenUrls.expectedFpp();
            }
        });
        metrics.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"unseenRate"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)BaseFrontier.this.incoming.getCount(), (double)BaseFrontier.this.totalIncoming);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Collection<CrawlUrl> urls) {
        Object object = this.lock;
        synchronized (object) {
            this.totalIncoming += (long)urls.size();
            for (CrawlUrl url : urls) {
                if (this.seenUrls.mightContain((Object)url.getUrl())) continue;
                this.incoming.mark();
                this.size.inc();
                this.pushInternal(url);
                this.seenUrls.put((Object)url.getUrl());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<CrawlUrl> pop() {
        Object object = this.lock;
        synchronized (object) {
            Optional<CrawlUrl> internal = this.popInternal();
            if (internal.isPresent()) {
                this.outgoing.mark();
                this.size.dec();
            } else {
                this.emptyQueue.mark();
            }
            return internal;
        }
    }

    protected abstract Optional<CrawlUrl> popInternal();

    protected abstract void pushInternal(CrawlUrl var1);

    @Override
    public void close() throws IOException {
        this.metrics.removeMatching((MetricFilter)new ClassMetricFilter(this.getClass()));
    }
}

