/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import de.l3s.icrawl.snapshots.SnaphotLocation;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

public class TimeSpecification
implements Comparator<SnaphotLocation> {
    private static final double DEFAULT_SHAPE = 1.0;
    private static final double LOG_OF_2 = Math.log(2.0);
    private static final long MILLIS_PER_DAY = Duration.ofDays(1L).toMillis();
    private final ZonedDateTime start;
    private final ZonedDateTime end;
    @JsonProperty
    private final Period beforeFuzziness;
    private final long beforeFuzzinessDuration;
    @JsonProperty
    private final Period afterFuzziness;
    private final long afterFuzzinessDuration;

    @JsonCreator
    TimeSpecification(@JsonProperty(value="start") @JsonDeserialize(using=LocalDateDeserializer.class) LocalDate start, @JsonProperty(value="end") @JsonDeserialize(using=LocalDateDeserializer.class) LocalDate end, @JsonProperty(value="beforeFuzziness") Period beforeFuzziness, @JsonProperty(value="afterFuzziness") Period afterFuzziness) {
        this.start = Objects.requireNonNull(start).atStartOfDay(ZoneOffset.UTC);
        this.end = Objects.requireNonNull(end).atStartOfDay(ZoneOffset.UTC);
        this.beforeFuzziness = Objects.requireNonNull(beforeFuzziness);
        this.afterFuzziness = Objects.requireNonNull(afterFuzziness);
        Instant now = Instant.now();
        this.beforeFuzzinessDuration = ChronoUnit.MILLIS.between(now, now.plus(beforeFuzziness));
        this.afterFuzzinessDuration = ChronoUnit.MILLIS.between(now, now.plus(afterFuzziness));
    }

    public static TimeSpecification afterDate(LocalDate start, Period afterFuzziness) {
        return new TimeSpecification(start, start, Period.ZERO, afterFuzziness);
    }

    public static TimeSpecification interval(LocalDate start, LocalDate end, Period fuzziness) {
        return new TimeSpecification(start, end, fuzziness, fuzziness);
    }

    public static TimeSpecification interval(LocalDate start, LocalDate end, Period beforeFuzziness, Period afterFuzziness) {
        return new TimeSpecification(start, end, beforeFuzziness, afterFuzziness);
    }

    public double getRelevance(ZonedDateTime t) {
        if (this.start.isBefore(t) && this.end.isAfter(t)) {
            return 1.0;
        }
        if (this.start.isAfter(t)) {
            long diff = Duration.between(t, this.start).toMillis();
            return this.weibull(diff, this.beforeFuzzinessDuration, 1.0);
        }
        long diff = Duration.between(this.end.plusDays(1L), t).toMillis();
        return this.weibull(diff, this.afterFuzzinessDuration, 1.0);
    }

    public double getRelevanceExp(ZonedDateTime t) {
        if (this.start.isBefore(t) && this.end.isAfter(t)) {
            return 1.0;
        }
        if (this.start.isAfter(t)) {
            long diff = Duration.between(t, this.start).toMillis();
            return this.exp(diff);
        }
        long diff = Duration.between(this.end.plusDays(1L), t).toMillis();
        return this.exp(diff);
    }

    private double exp(long diff) {
        return Math.exp(-diff / (2L * MILLIS_PER_DAY));
    }

    private double weibull(long t, double halfDecay, double shape) {
        double scaled = (double)t / halfDecay;
        double shaped = -Math.pow(scaled, shape);
        return Math.exp(shaped * LOG_OF_2);
    }

    public Optional<SnaphotLocation> findBest(Iterable<SnaphotLocation> locations) {
        if (Iterables.isEmpty(locations)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Ordering.from((Comparator)this).reverse().min(locations));
    }

    public Iterable<SnaphotLocation> findBest(Iterable<SnaphotLocation> locations, int maxResults) {
        if (Iterables.size(locations) < maxResults) {
            return locations;
        }
        return Ordering.from((Comparator)this).reverse().leastOf(locations, maxResults);
    }

    @Override
    public int compare(SnaphotLocation a, SnaphotLocation b) {
        if (a.getCrawlTime() == null && b.getCrawlTime() == null) {
            return 0;
        }
        if (a.getCrawlTime() == null) {
            return -1;
        }
        if (b.getCrawlTime() == null) {
            return 1;
        }
        return Doubles.compare((double)this.getRelevance(b.getCrawlTime()), (double)this.getRelevance(a.getCrawlTime()));
    }

    public boolean contains(ZonedDateTime t) {
        return t != null && this.start.isBefore(t) && this.end.isAfter(t);
    }

    public String toString() {
        return String.format("%s-%s (%s/%s)", this.start, this.end, this.beforeFuzziness, this.afterFuzziness);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TimeSpecification)) {
            return false;
        }
        TimeSpecification o = (TimeSpecification)obj;
        return Objects.equals(this.start, o.start) && Objects.equals(this.end, o.end) && Objects.equals(this.beforeFuzziness, o.beforeFuzziness) && Objects.equals(this.afterFuzziness, o.afterFuzziness);
    }

    @JsonProperty
    @JsonSerialize(using=LocalDateSerializer.class)
    public LocalDate getStart() {
        return this.start.toLocalDate();
    }

    @JsonProperty
    @JsonSerialize(using=LocalDateSerializer.class)
    public LocalDate getEnd() {
        return this.end.toLocalDate();
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.beforeFuzziness, this.afterFuzziness);
    }
}

