/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.l3s.icrawl.crawler.ArchiveCrawlSpecification;
import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.crawler.CrawlerThread;
import de.l3s.icrawl.crawler.analysis.ResourceAnalyser;
import de.l3s.icrawl.crawler.analysis.ResourceAnalyserFactory;
import de.l3s.icrawl.crawler.frontier.FileBasedFrontier;
import de.l3s.icrawl.crawler.io.ArchiveFetcher;
import de.l3s.icrawl.crawler.io.ResultStorer;
import de.l3s.icrawl.crawler.scheduling.StoppingCriterion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    private static final String PROGRESS_METRIC_KEY = "progress";
    public static final String NUM_URLS = "de_l3s_icrawl_crawler_numUrls";
    public static final String WEIGHTING_METHOD = "de_l3s_icrawl_crawler_weightingMethod";
    public static final String RELEVANCE_THRESHOLD = "de_l3s_icrawl_crawler_relevanceThreshold";
    public static final String SNAPSHOTS_TO_ANALYZE = "de_l3s_icrawl_crawler_snapshotsToAnalyze";
    private static final Logger logger = LoggerFactory.getLogger(Crawler.class);
    private static final int PRIORITY_STEPS = 100;
    private static final float INJECT_PRIORITY = 1.0f;
    private final MetricRegistry metrics;
    private final int numThreads;
    private final ResourceAnalyserFactory analyserFactory;
    private final String indexPath;
    private final String dataPath;
    private final ResultStorer.Factory storerFactory;
    private final ExecutorService threadPool;
    private List<CrawlerThread> threads;
    private ArchiveCrawlSpecification spec;
    private List<Future<?>> threadFutures;
    private final Configuration conf;

    public Crawler(Configuration conf, String indexPath, String dataPath, ResourceAnalyserFactory analyserFactory, ResultStorer.Factory storerFactory, MetricRegistry metrics, int numThreads) throws IOException {
        this.conf = conf;
        this.indexPath = indexPath;
        this.dataPath = dataPath;
        this.analyserFactory = analyserFactory;
        this.storerFactory = storerFactory;
        this.metrics = metrics;
        this.numThreads = numThreads;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("fetcher-%d").setUncaughtExceptionHandler((t, e) -> logger.warn("Uncaught exception in {} ", (Object)t, (Object)e)).build();
        this.threadPool = Executors.newFixedThreadPool(numThreads + 1, threadFactory);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Running shutdown hook");
            this.shutdown();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crawlContinuously(ArchiveCrawlSpecification spec, StoppingCriterion stoppingCriterion, ResourceAnalyser.WeightingMethod method, double relevanceThreshold, int snapshotsToAnalyze) throws IOException {
        this.spec = spec;
        logger.info("Starting crawl with {} threads", (Object)this.numThreads);
        stoppingCriterion.addListener(() -> this.stop(false));
        this.metrics.register(PROGRESS_METRIC_KEY, (Metric)stoppingCriterion);
        File queueDirectory = new File(spec.getName() + ".frontier");
        String outputName = String.format("%s-%s-%d", spec.getName(), method.name(), snapshotsToAnalyze);
        try (ResultStorer storer = this.storerFactory.get(outputName);
             FileBasedFrontier queue = new FileBasedFrontier(queueDirectory, this.metrics, 100, false);){
            Set<CrawlUrl> seeds = spec.getSeedUrls().stream().map(url -> CrawlUrl.fromSeed(url, 1.0f)).collect(Collectors.toSet());
            queue.push(seeds);
            this.threads = new ArrayList<CrawlerThread>(this.numThreads);
            CountDownLatch barrier = new CountDownLatch(this.numThreads);
            for (int i = 0; i < this.numThreads; ++i) {
                ResourceAnalyser analyser = this.analyserFactory.get(spec, method);
                ArchiveFetcher fetcher = new ArchiveFetcher(this.conf, this.indexPath, this.dataPath, this.metrics, snapshotsToAnalyze);
                this.threads.add(new CrawlerThread(queue, fetcher, storer, analyser, this.metrics, spec, barrier, stoppingCriterion, relevanceThreshold));
            }
            this.threadFutures = this.threads.stream().map(this.threadPool::submit).collect(Collectors.toList());
            logger.info("Started {} crawler threads, waiting for them to finish", (Object)barrier.getCount());
            try {
                barrier.await();
                logger.info("All threads finished, done.");
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while waiting for crawl to finish, stopping crawl");
                this.stop(true);
            }
        }
        finally {
            this.spec = null;
            this.metrics.remove(PROGRESS_METRIC_KEY);
        }
    }

    public void stop(boolean interruptRunningFetches) {
        logger.info("Stopping crawler");
        this.threadPool.submit(() -> {
            if (this.threads != null) {
                this.threads.forEach(CrawlerThread::stop);
            }
            if (this.threadFutures != null) {
                for (Future<?> threadFuture : this.threadFutures) {
                    try {
                        threadFuture.get(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException e1) {
                        logger.info("Exception while waiting for stopped thread", (Throwable)e1);
                    }
                    catch (TimeoutException e2) {
                        logger.info("CrawlerThread {} did not shut down in the allocated time", threadFuture, (Object)e2);
                    }
                }
            }
        });
    }

    public void shutdown() {
        this.stop(true);
        boolean stopped = false;
        try {
            this.threadPool.shutdown();
            stopped = this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            stopped = false;
        }
        if (!stopped) {
            logger.warn("Could not stop all running fetchers");
            this.threadPool.shutdownNow();
        } else {
            logger.info("Stopped crawler");
        }
    }

    public Optional<ArchiveCrawlSpecification> getCurrentSpec() {
        return Optional.ofNullable(this.spec);
    }
}

