/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler;

import de.l3s.icrawl.crawler.CrawlUrl;
import de.l3s.icrawl.snapshots.Snapshot;
import java.time.Duration;
import java.time.ZonedDateTime;
import org.springframework.core.style.ToStringCreator;

public class CrawledResource {
    private final String url;
    private final String path;
    private final float crawlPriority;
    private final Snapshot resource;
    private final double relevance;
    private final ZonedDateTime modifiedDate;
    private Duration snapshotsDuration;
    private double minRelevance = -1.0;
    private double maxRelevance = -1.0;

    public CrawledResource(CrawlUrl url, Snapshot resource, double relevance, ZonedDateTime modifiedDate) {
        this.resource = resource;
        this.relevance = relevance;
        this.modifiedDate = modifiedDate;
        this.url = url.getUrl();
        this.path = url.getPath();
        this.crawlPriority = url.getPriority();
    }

    public CrawledResource(CrawlUrl url, Snapshot resource, double relevance, ZonedDateTime modifiedDate, Duration snapshotsDuration, double minRelevance, double maxRelevance) {
        this(url, resource, relevance, modifiedDate);
        this.snapshotsDuration = snapshotsDuration;
        this.minRelevance = minRelevance;
        this.maxRelevance = maxRelevance;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public float getCrawlPriority() {
        return this.crawlPriority;
    }

    public Snapshot getResource() {
        return this.resource;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public ZonedDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public Duration getSnapshotsDuration() {
        return this.snapshotsDuration;
    }

    public double getMinRelevance() {
        return this.minRelevance;
    }

    public double getMaxRelevance() {
        return this.maxRelevance;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("url", (Object)this.url).append("crawlTime", (Object)this.resource.getCrawlTime()).append("relevance", this.relevance).append("mimeType", (Object)this.resource.getMimeType()).append("status", this.resource.getStatus()).append("path", (Object)this.path).append("crawlPriority", this.crawlPriority).toString();
    }
}

