/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Objects;

public class CrawlUrl {
    private final String url;
    private final String path;
    private final float priority;
    private final String referrer;
    private final ZonedDateTime refererCrawlTime;

    public CrawlUrl(String url, String path, float priority, String referrer, ZonedDateTime refererCrawlTime) {
        Objects.requireNonNull(url);
        Preconditions.checkArgument((path != null && !path.isEmpty() ? 1 : 0) != 0, (String)"Invalid path: '%s'", (Object[])new Object[]{path});
        Preconditions.checkArgument((0.0f <= priority && priority <= 1.0f ? 1 : 0) != 0, (String)"Invalid priority, %s not in [0,1]", (Object[])new Object[]{Float.valueOf(priority)});
        Preconditions.checkArgument((referrer == null == (refererCrawlTime == null) ? 1 : 0) != 0, (Object)"Referrer and crawl time must be give together or not at all");
        this.url = url;
        this.path = path;
        this.priority = priority;
        this.referrer = referrer;
        this.refererCrawlTime = refererCrawlTime;
    }

    public static CrawlUrl fromSeed(String url, float priority) {
        return new CrawlUrl(url, Character.toString(Path.SEED.getName()), priority, null, null);
    }

    public CrawlUrl outlink(String url, float priority, ZonedDateTime crawlTime) {
        return new CrawlUrl(url, this.path + Path.LINK.getName(), priority, this.url, crawlTime);
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public float getPriority() {
        return this.priority;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public ZonedDateTime getRefererCrawlTime() {
        return this.refererCrawlTime;
    }

    public String toString() {
        return String.format("%s (%s)", this.url, this.path);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlUrl)) {
            return false;
        }
        return this.url.equals(((CrawlUrl)obj).url);
    }

    public CrawlUrl merge(CrawlUrl mergee) {
        if (!this.url.equals(mergee.url)) {
            return this;
        }
        return this.path.length() <= mergee.path.length() ? this : mergee;
    }

    public static enum Path {
        SEED('S'),
        LINK('L');

        private final char name;

        private Path(char name) {
            this.name = name;
        }

        public char getName() {
            return this.name;
        }
    }
}

