/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.crawler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.l3s.icrawl.contentanalysis.DocumentVector;
import de.l3s.icrawl.crawler.TimeSpecification;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ArchiveCrawlSpecification {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule()}).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private final String name;
    private final List<String> seedUrls;
    private final List<String> referenceDocuments;
    private final TimeSpecification referenceTime;
    private final Map<Locale, DocumentVector> referenceVectors;
    private final String description;
    private final Map<Locale, Set<String>> keywords;
    private final Locale defaultLanguage;
    private final Map<Locale, Double> correctionFactors;

    @JsonCreator
    public ArchiveCrawlSpecification(@JsonProperty(value="name") String name, @JsonProperty(value="seedUrls") List<String> seedUrls, @JsonProperty(value="referenceDocuments") List<String> referenceDocuments, @JsonProperty(value="referenceTime") TimeSpecification referenceTime, @JsonProperty(value="referenceVectors") Map<Locale, DocumentVector> referenceVectors, @JsonProperty(value="keywords") Map<Locale, Set<String>> keywords, @JsonProperty(value="description") String description, @JsonProperty(value="defaultLanguage") Locale defaultLanguage, @JsonProperty(value="correctionFactors") Map<Locale, Double> correctionFactors) {
        this.name = name;
        this.seedUrls = seedUrls;
        this.referenceDocuments = referenceDocuments;
        this.referenceTime = referenceTime;
        this.defaultLanguage = defaultLanguage;
        this.correctionFactors = correctionFactors;
        this.referenceVectors = Objects.requireNonNull(referenceVectors);
        this.keywords = keywords;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSeedUrls() {
        return this.seedUrls;
    }

    public List<String> getReferenceDocuments() {
        return this.referenceDocuments;
    }

    public TimeSpecification getReferenceTime() {
        return this.referenceTime;
    }

    public Map<Locale, DocumentVector> getReferenceVectors() {
        return Collections.unmodifiableMap(this.referenceVectors);
    }

    public String getDescription() {
        return this.description;
    }

    public Map<Locale, Double> getCorrectionFactors() {
        return this.correctionFactors;
    }

    public static ArchiveCrawlSpecification readFile(File specFile) throws IOException {
        return (ArchiveCrawlSpecification)MAPPER.readValue(specFile, ArchiveCrawlSpecification.class);
    }

    public void writeFile(File specFile) throws IOException {
        MAPPER.writeValue(specFile, (Object)this);
    }

    public Map<Locale, Set<String>> getKeywords() {
        return this.keywords;
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.seedUrls, this.referenceDocuments, this.referenceTime, this.keywords, this.defaultLanguage, this.description, this.correctionFactors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArchiveCrawlSpecification)) {
            return false;
        }
        ArchiveCrawlSpecification o = (ArchiveCrawlSpecification)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.seedUrls, o.seedUrls) && Objects.equals(this.referenceDocuments, o.referenceDocuments) && Objects.equals(this.referenceTime, o.referenceTime) && Objects.equals(this.keywords, o.keywords) && Objects.equals(this.defaultLanguage, o.defaultLanguage) && Objects.equals(this.description, o.description) && Objects.equals(this.correctionFactors, o.correctionFactors);
    }

    public ArchiveCrawlSpecification withSeedUrls(List<String> newSeedUrls) {
        return new ArchiveCrawlSpecification(this.name, newSeedUrls, this.referenceDocuments, this.referenceTime, this.referenceVectors, this.keywords, this.description, this.defaultLanguage, this.correctionFactors);
    }
}

