/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.contentanalysis;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

class TreeWalker
implements Iterable<Node> {
    private final Set<String> skippedElements;
    private final Node startNode;

    public TreeWalker(Node n, Set<String> skippedElements) {
        this.startNode = n;
        this.skippedElements = Objects.requireNonNull(skippedElements);
    }

    @Override
    public Iterator<Node> iterator() {
        return new TreeIterator(this.startNode);
    }

    private class TreeIterator
    extends AbstractIterator<Node> {
        private Node currentNode;
        private int depth = 0;
        private boolean finished = false;

        public TreeIterator(Node n) {
            this.currentNode = n;
        }

        protected Node computeNext() {
            Node returnedNode = this.currentNode;
            if (this.finished) {
                return (Node)this.endOfData();
            }
            do {
                if (this.currentNode.childNodeSize() > 0 && !this.isSkippedNode(this.currentNode)) {
                    this.currentNode = this.currentNode.childNode(0);
                    ++this.depth;
                    continue;
                }
                while (this.currentNode.nextSibling() == null && this.depth > 0) {
                    this.currentNode = this.currentNode.parentNode();
                    --this.depth;
                }
                if (this.currentNode == TreeWalker.this.startNode) {
                    this.finished = true;
                    break;
                }
                this.currentNode = this.currentNode.nextSibling();
            } while (this.isSkippedNode(this.currentNode));
            return returnedNode != null ? returnedNode : (Node)this.endOfData();
        }

        boolean isSkippedNode(Node node) {
            return node instanceof Element && TreeWalker.this.skippedElements.contains(((Element)node).tagName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Node prevCurrentNode = this.currentNode;
            int prevDepth = this.depth;
            boolean prevFinished = this.finished;
            try {
                String string = Iterators.toString((Iterator)((Object)this));
                return string;
            }
            finally {
                this.currentNode = prevCurrentNode;
                this.depth = prevDepth;
                this.finished = prevFinished;
            }
        }
    }
}

