/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.contentanalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.sharethis.textrank.MetricVector;
import com.sharethis.textrank.TextRank;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TextRankWrapper {
    private final TextRank englishTextRank = new TextRank("res", "en");
    private final TextRank germanTextRank = new TextRank("res", "de");

    public List<String> rank(String text, Locale lang, int k) {
        TextRank ranker;
        Preconditions.checkArgument((k >= 0 ? 1 : 0) != 0, (String)"k must be greater or equal 0, but is %s", (Object[])new Object[]{k});
        Preconditions.checkNotNull((Object)text, (Object)"Text must not be null");
        switch (lang.getLanguage()) {
            case "en": {
                ranker = this.englishTextRank;
                break;
            }
            case "de": {
                ranker = this.germanTextRank;
                break;
            }
            default: {
                ranker = this.englishTextRank;
            }
        }
        ranker.prepCall(text, false);
        Object col = ranker.call();
        ArrayList ret = Lists.newArrayListWithExpectedSize((int)k);
        for (MetricVector mv : Ordering.natural().greatestOf((Iterable)col, k)) {
            ret.add(mv.value.text);
        }
        return ret;
    }

    public static enum LANG_CODE {
        DE("de"),
        EN("en");

        private String lang;

        private LANG_CODE(String s) {
            this.lang = s;
        }

        public String getLangCode() {
            return this.lang;
        }
    }
}

