/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.contentanalysis;

import de.l3s.icrawl.contentanalysis.Labeler;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.util.CoreMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.openimaj.text.nlp.language.LanguageDetector;

public class LabelerFactory {
    private final Map<String, Labeler> labelers;
    private final String defaultLabeler;
    private final Function<String, Labeler> provider;

    public LabelerFactory(Map<String, Labeler> labelers, String defaultLabelerLanguage, Function<String, Labeler> provider) {
        this.labelers = labelers;
        this.defaultLabeler = defaultLabelerLanguage;
        this.provider = provider;
    }

    public static LabelerFactory defaultFactory() {
        Function<String, Labeler> provider = new Function<String, Labeler>(){

            @Override
            public Labeler apply(String language) {
                if ("en".equals(language)) {
                    return new Labeler((CRFClassifier<CoreMap>)CRFClassifier.getClassifierNoExceptions((String)"english.all.3class.distsim.crf.ser.gz"), Locale.ENGLISH, "PERSON", "ORGANIZATION", "LOCATION");
                }
                if ("de".equals(language)) {
                    return new Labeler((CRFClassifier<CoreMap>)CRFClassifier.getClassifierNoExceptions((String)"dewac_175m_600.crf.ser.gz"), Locale.GERMAN, "I-PER", "I-ORG", "I-LOC");
                }
                return null;
            }
        };
        return new LabelerFactory(new HashMap<String, Labeler>(), "en", provider);
    }

    public Labeler get(LanguageDetector.WeightedLocale locale) {
        Labeler labeler = this.getInternal(locale.language);
        return labeler != null ? labeler : this.getInternal(this.defaultLabeler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Labeler getInternal(String language) {
        Map<String, Labeler> map = this.labelers;
        synchronized (map) {
            Labeler labeler = this.labelers.get(language);
            if (labeler == null && this.provider != null && (labeler = this.provider.apply(language)) != null) {
                this.labelers.put(language, labeler);
            }
            return labeler;
        }
    }
}

