/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.contentanalysis;

import com.google.common.collect.Lists;
import de.l3s.icrawl.domain.specification.NamedEntity;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Labeler {
    private static final Logger logger = LoggerFactory.getLogger(Labeler.class);
    private final CRFClassifier<CoreMap> classifier;
    private final String personTag;
    private final String organisationTag;
    private final String locationTag;
    private final Locale language;

    public Labeler(CRFClassifier<CoreMap> classifier, Locale language, String personTag, String organisationTag, String locationTag) {
        this.classifier = classifier;
        this.language = language;
        this.personTag = personTag;
        this.organisationTag = organisationTag;
        this.locationTag = locationTag;
    }

    @Nullable
    protected NamedEntity.Type map(String annotationType) {
        if (this.personTag.equals(annotationType)) {
            return NamedEntity.Type.PERSON;
        }
        if (this.organisationTag.equals(annotationType)) {
            return NamedEntity.Type.ORGANIZATION;
        }
        if (this.locationTag.equals(annotationType)) {
            return NamedEntity.Type.LOCATION;
        }
        logger.trace("Unknown annotation type {}", (Object)annotationType);
        return null;
    }

    public Collection<NamedEntity> extractEntities(String text) {
        List annotations = this.classifier.classifyToCharacterOffsets(text);
        ArrayList entities = Lists.newArrayListWithExpectedSize((int)annotations.size());
        for (Triple el : annotations) {
            NamedEntity.Type type = this.map((String)el.first);
            if (type == null) continue;
            NamedEntity.Label label = new NamedEntity.Label(Labeler.label(text, (Triple<String, Integer, Integer>)el), this.language);
            entities.add(new NamedEntity(type, label));
        }
        return entities;
    }

    private static String label(String text, Triple<String, Integer, Integer> annotation) {
        return text.substring((Integer)annotation.second, (Integer)annotation.third).replaceAll("[^-\\w\\d_]+", " ").trim();
    }
}

