/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.icrawl.contentanalysis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentVector
implements Serializable {
    private static final Ordering<Map.Entry<String, Double>> ORDER_BY_WEIGHT = Ordering.natural().onResultOf(Map.Entry::getValue);
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private final Map<String, Double> elements;
    private final double norm;

    @JsonCreator
    public DocumentVector(@JsonProperty(value="elements") Map<String, Double> elements) {
        this.elements = Objects.requireNonNull(elements);
        this.norm = DocumentVector.norm(elements);
    }

    public DocumentVector(Collection<String> tokens) {
        this(DocumentVector.toDocumentVector(tokens));
    }

    private static Map<String, Double> toDocumentVector(Collection<String> tokens) {
        HashMultiset counts = HashMultiset.create(tokens);
        HashMap dv = Maps.newHashMapWithExpectedSize((int)counts.elementSet().size());
        double size = tokens.size();
        for (Multiset.Entry entry : counts.entrySet()) {
            dv.put(entry.getElement(), (double)entry.getCount() / size);
        }
        return dv;
    }

    public double cosineSimilarity(DocumentVector other) {
        return this.dotProduct(other) / (this.norm * other.norm);
    }

    public double dotProduct(DocumentVector other) {
        Sets.SetView bothTokens = Sets.intersection(this.elements.keySet(), other.elements.keySet());
        double dotProduct = 0.0;
        for (String token : bothTokens) {
            dotProduct += this.elements.get(token) * other.elements.get(token);
        }
        return dotProduct;
    }

    public static DocumentVector merge(Collection<DocumentVector> vectors, boolean useDocumentFrequency) {
        Preconditions.checkArgument((!vectors.isEmpty() ? 1 : 0) != 0, (Object)"Cannot merge zero vectors");
        int expectedSize = vectors.size() * vectors.iterator().next().elements.size();
        HashMultiset keys = HashMultiset.create((int)expectedSize);
        for (DocumentVector vector : vectors) {
            keys.addAll(vector.elements.keySet());
        }
        HashMap mergedValues = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (Multiset.Entry key : keys.entrySet()) {
            double sum = 0.0;
            for (DocumentVector vector : vectors) {
                Double vectorValue = vector.elements.get(key.getElement());
                if (vectorValue == null) continue;
                sum += vectorValue.doubleValue();
            }
            if (useDocumentFrequency) {
                sum *= (double)key.getCount() / (double)vectors.size();
            }
            mergedValues.put(key.getElement(), sum);
        }
        return new DocumentVector(mergedValues);
    }

    private static <T> double norm(Map<T, Double> dv) {
        double sum = 0.0;
        for (Double value : dv.values()) {
            sum += value * value;
        }
        return Math.sqrt(sum);
    }

    public DocumentVector topN(int n) {
        HashMap<String, Double> newElements = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : this.topComponents(n)) {
            newElements.put(entry.getKey(), entry.getValue());
        }
        return new DocumentVector(newElements);
    }

    public List<Map.Entry<String, Double>> topComponents(int count) {
        return ORDER_BY_WEIGHT.greatestOf(this.elements.entrySet(), count);
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.norm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentVector other = (DocumentVector)obj;
        if (Double.doubleToLongBits(this.norm) != Double.doubleToLongBits(other.norm)) {
            return false;
        }
        return this.elements.equals(other.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").withKeyValueSeparator(": ").appendTo(sb, (Iterable)ORDER_BY_WEIGHT.sortedCopy(this.elements.entrySet()));
        return sb.append("}").toString();
    }
}

