/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.Graph;
import com.sharethis.textrank.LanguageModel;
import com.sharethis.textrank.MetricVector;
import com.sharethis.textrank.NGram;
import com.sharethis.textrank.Node;
import com.sharethis.textrank.Sentence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class TextRank
implements Callable<Collection<MetricVector>> {
    public static final String NLP_RESOURCES = "nlp.resources";
    public static final double MIN_NORMALIZED_RANK = 0.05;
    public static final int MAX_NGRAM_LENGTH = 5;
    public static final long MAX_WORDNET_TEXT = 2000L;
    public static final long MAX_WORDNET_GRAPH = 600L;
    protected final LanguageModel lang;
    protected String text = null;
    protected boolean use_wordnet = false;
    protected Graph graph = null;
    protected Graph ngram_subgraph = null;
    protected Map<NGram, MetricVector> metric_space = null;
    protected long start_time = 0L;
    protected long elapsed_time = 0L;

    public TextRank(String res_path, String lang_code) {
        this.lang = LanguageModel.buildLanguage(lang_code);
    }

    public void prepCall(String text, boolean use_wordnet) {
        this.graph = new Graph();
        this.ngram_subgraph = null;
        this.metric_space = new HashMap<NGram, MetricVector>();
        this.text = text;
        this.use_wordnet = use_wordnet;
    }

    @Override
    public Collection<MetricVector> call() {
        ArrayList<Sentence> s_list = new ArrayList<Sentence>();
        for (String sent_text : this.lang.splitParagraph(this.text)) {
            Sentence s = this.lang.parseSentence(sent_text.trim());
            s.mapTokens(this.lang, this.graph);
            s_list.add(s);
        }
        int max_results = (int)Math.round((double)this.graph.size() * 0.8);
        this.graph.runTextRank();
        this.graph.sortResults(max_results);
        this.ngram_subgraph = NGram.collectNGrams(this.lang, s_list, this.graph.getRankThreshold());
        Graph synset_subgraph = new Graph();
        for (Node n : this.ngram_subgraph.values()) {
            NGram gram = (NGram)n.value;
            if (gram.length >= 5) continue;
            this.graph.put(n.key, n);
            for (Node keyword_node : gram.nodes) {
                n.connect(keyword_node);
            }
        }
        this.graph.runTextRank();
        int ngram_max_count = NGram.calcStats(this.ngram_subgraph);
        double link_min = this.ngram_subgraph.dist_stats.getMin();
        double link_coeff = this.ngram_subgraph.dist_stats.getMax() - this.ngram_subgraph.dist_stats.getMin();
        double count_min = 1.0;
        double count_coeff = (double)ngram_max_count - 1.0;
        double synset_min = synset_subgraph.dist_stats.getMin();
        double synset_coeff = synset_subgraph.dist_stats.getMax() - synset_subgraph.dist_stats.getMin();
        for (Node n : this.ngram_subgraph.values()) {
            NGram gram = (NGram)n.value;
            if (gram.length >= 5) continue;
            double link_rank = (n.rank - link_min) / link_coeff;
            double count_rank = ((double)gram.getCount() - 1.0) / count_coeff;
            double synset_rank = this.use_wordnet ? n.maxNeighbor(synset_min, synset_coeff) : 0.0;
            MetricVector mv = new MetricVector(gram, link_rank, count_rank, synset_rank);
            this.metric_space.put(gram, mv);
        }
        return this.metric_space.values();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String toString() {
        TreeSet<MetricVector> key_phrase_list = new TreeSet<MetricVector>(this.metric_space.values());
        StringBuilder sb = new StringBuilder();
        for (MetricVector mv : key_phrase_list) {
            if (!(mv.metric >= 0.05)) continue;
            sb.append(mv.render()).append("\t").append(mv.value.text).append("\n");
        }
        return sb.toString();
    }
}

